% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mazeObject.R
\name{mazeObject}
\alias{mazeObject}
\title{Generate Elithorn Maze}
\usage{
mazeObject(rank = 3, satPercent = 0.5, seed = 1, grid = NULL,
  background = "#7abcff", boxBackground = "#66CDAA", fontColour = "white",
  Timer = TRUE, concerto = "C5")
}
\arguments{
\item{rank}{This is the Rank of the maze.}

\item{satPercent}{The saturation of the number of black dots created for a given grid. Range between 0-1.}

\item{seed}{To make sure that the randomness of the created black dots is captured and not repeated.}

\item{grid}{is the grid of the maze}

\item{background}{The background colour of the page.}

\item{boxBackground}{The background colour of the box.}

\item{fontColour}{The font colour of the instructions.}

\item{Timer}{If True, a time limit of 4 mintues is given per question.}

\item{concerto}{The code varies between concerto version "C4" and "C5".}
}
\description{
This function generates the html template of the Elithorn Maze in an R object.
}
\details{
This function creates a plot with the maze blueprint into your working directory.
A grid object needs to be called out first before runing the maze function.
The grid object needs to be the same as the rank given.
}
\examples{

rank <- 3
satPercent <- 0.5

#Grid must be same as rank
grid <- gridThreeUp

#Generate item
mazeObject(rank,satPercent,seed=5,grid = grid,
background="#7abcff",boxBackground="#66CDAA", fontColour="white ",
Timer=TRUE, concerto="C5")



}
\author{
Aiden Loe
}
\seealso{
\code{\link{mazeAbility}}, \code{\link{mazeDiff}}, \code{\link{np}}
}

