% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{sum_byname}
\alias{sum_byname}
\title{Name-wise addition of matrices}
\usage{
sum_byname(..., .summarise = FALSE)
}
\arguments{
\item{...}{Operands: constants, matrices, or lists of matrices.}

\item{.summarise}{When \code{TRUE}, a operands are summed down lists.
When \code{FALSE} (the default), items are summed across lists.}
}
\value{
A matrix representing the name-wise sum of arguments.
}
\description{
Performs a union and sorting of addend and augend row and column names prior to summation.
Zeroes are inserted for missing matrix elements.
Treats missing or \code{NULL} operands as \code{0}.
}
\details{
For this function, a list of lists of operands is ambiguous.
Should the operands be summed across lists
(first items summed across all lists, second items summed across all list, etc.)
or should each list be summed along each list?
In the first case, the return object will have length equal to the length of the lists in the \code{...} argument.
In the second case, the return object will have length equal to the number of lists in the \code{...} argument.
The first case is like summing across rows of a data frame.
The second case is like summing down columns of a data frame.
The \code{summarise} argument distinguishes between these two cases.
The default value for \code{summarise} is \code{FALSE}, giving the first behavior.
Set \code{summarise} to \code{TRUE} to cause this function to act like \code{dplyr::summarise()}
for its list of arguments.
If \code{.summarise = TRUE}, the
data value is guaranteed to be a list.
If the call to \code{sum_byname(.summarise = TRUE)} is made in the context of a data frame,
the column returned is guaranteed to be a list column.
See the aggregation vignette for additional details and examples.
}
\examples{
library(dplyr)
sum_byname(2, 2)
sum_byname(2, 2, 2)
sum_byname(2, 2, -2, -2)
productnames <- c("p1", "p2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(productnames, industrynames)) \%>\%
  setrowtype("Products") \%>\% setcoltype("Industries")
Y <- matrix(1:4, ncol = 2, dimnames = list(rev(productnames), rev(industrynames))) \%>\%
  setrowtype("Products") \%>\% setcoltype("Industries")
sum_byname(U, 100)
sum_byname(200, Y)
U + Y # Non-sensical.  Row and column names not respected.
sum_byname(U, U)
sum_byname(U, Y)
sum_byname(U, U, Y, Y)
V <- matrix(1:4, ncol = 2, dimnames = list(industrynames, productnames)) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Products")
U + V # row and column names are non-sensical and blindly taken from first argument (U)
\dontrun{sum_byname(U, V)} # Fails, because row and column types are different
# This also works with lists
sum_byname(list(U,U), list(Y,Y))
sum_byname(list(U,U), list(100,100))
sum_byname(list(U,U), as.list(rep_len(100, 2)))
DF <- data.frame(U = I(list()), Y = I(list()))
DF[[1,"U"]] <- U
DF[[2,"U"]] <- U
DF[[1,"Y"]] <- Y
DF[[2,"Y"]] <- Y
sum_byname(DF$U, DF$Y)
DF \%>\% mutate(sums = sum_byname(U, Y))
sum_byname(U) # If only one argument, return it.
sum_byname(2, NULL) # Gives 2
sum_byname(2, NA)   # Gives NA
sum_byname(NULL, 1) # Gives 1
sum_byname(list(NULL, 1), list(1, 1))
DF2 <- data.frame(U = I(list()), Y = I(list()))
DF2[[1,"U"]] <- NULL
DF2[[2,"U"]] <- U
DF2[[1,"Y"]] <- Y
DF2[[2,"Y"]] <- Y
sum_byname(DF2$U, DF2$Y)
DF3 <- DF2 \%>\% mutate(sums = sum_byname(U, Y))
DF3
DF3$sums[[1]]
DF3$sums[[2]]
}
