% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{hatize_byname}
\alias{hatize_byname}
\title{Creates a diagonal "hat" matrix from a vector}
\usage{
hatize_byname(v)
}
\arguments{
\item{v}{The vector from which a "hat" matrix is to be created.}
}
\value{
A square "hat" matrix with size equal to the length of \code{v}.
}
\description{
A "hat" matrix is one in which the only non-zero elements are stored on the diagonal.
To "hatize" a vector is to place its elements on the diagonal of an otherwise-zero square matrix.
\code{v} must be a matrix object with one of its two dimensions of length 1 (i.e., a vector).
The names of both dimensions of the hatized matrix are the same and taken from \code{v}.
Note that the vector names are sorted prior to forming the "hat" matrix.
}
\examples{
v <- matrix(1:10, ncol = 1, dimnames = list(c(paste0("i", 1:10)), c("c1"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype(NA)
hatize_byname(v)
r <- matrix(1:5, nrow = 1, dimnames = list(c("r1"), c(paste0("c", 1:5)))) \%>\%
  setrowtype(NA) \%>\% setcoltype("Commodities")
hatize_byname(r)
# This also works with lists.
hatize_byname(list(v, v))
# A 1x1 column vector is a degenerate case. 
# Row names and rowtype are transferred to the column.
matrix(42, nrow = 1, ncol = 1, dimnames = list("r1")) \%>\% 
  setrowtype("Product -> Industry") \%>\% 
  hatize_byname()
# A 1x1 row vector is a degenerate case. 
# Column names and coltype are transferred to the row.
matrix(42, nrow = 1, ncol = 1, dimnames = list(NULL, "c1")) \%>\% 
  setcoltype("Industry -> Product") \%>\% 
  hatize_byname()
# A 1x1 matrix with both row and column names generates a failure.
\dontrun{
matrix(42, nrow = 1, ncol = 1, dimnames = list("r1", "c1")) \%>\% 
  setrowtype("Product -> Industry") \%>\% 
  setcoltype("Industry -> Product") \%>\% 
  hatize_byname()
}
}
