% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.R
\name{unaryapply_byname}
\alias{unaryapply_byname}
\title{Apply a unary function by name}
\usage{
unaryapply_byname(
  FUN,
  a,
  .FUNdots = NULL,
  rowcoltypes = c("all", "transpose", "row", "col", "none")
)
}
\arguments{
\item{FUN}{a unary function to be applied "by name" to \code{a}.}

\item{a}{the argument to \code{FUN}.}

\item{.FUNdots}{a list of additional named arguments passed to \code{FUN}.}

\item{rowcoltypes}{a string that tells how to transfer row and column types of \code{a} to output.
Options are:
\itemize{
\item{\code{all}: transfer both row and column types of \code{a} directly to output.}
\item{\code{transpose}: rowtype of \code{a} becomes coltype of output;
coltype of \code{a} becomes rowtype of output.
"transpose" is helpful for \code{FUN}s that transpose
\code{a} upon output.}
\item{\code{row}: rowtype of \code{a} becomes both rowtype and coltype of output.}
\item{\code{col}: coltype of \code{a} becomes both rowtype and coltype of output.}
\item{\code{none}: rowtype and coltype not set by \code{unaryapply_byname}.
Rather, \code{FUN} will set rowtype and coltype.}
}}
}
\value{
the result of applying \code{FUN} "by name" to \code{a}.
}
\description{
\code{FUN} is applied to \code{a} using additional arguments \code{.FUNdots} to \code{FUN}.
If \code{a} is a list, the names of \code{a} are applied to the output.
}
\details{
Note that \code{.FUNdots} can be a rectangular two-dimensional list of arguments to \code{FUN}.
If so, \code{.FUNdots} is interpreted as follows:
\itemize{
\item The first dimension of \code{.FUNdots} contains named arguments to \code{FUN}.
\item The second dimension of \code{.FUNdots} contains unique values of the named arguments
to be applied along the list that is \code{a}.
}

The length of the first dimension of \code{.FUNdots} is the number of arguments supplied to \code{FUN}.
The length of the second dimension of \code{.FUNdots} must be equal to the length of \code{a}.
}
\examples{
productnames <- c("p1", "p2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(productnames, industrynames)) \%>\%
  setrowtype("Products") \%>\% setcoltype("Industries")
difference_byname(0, U)
unaryapply_byname(`-`, U)
}
