% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num2str.R
\name{num2str}
\alias{num2str}
\alias{num2str,numeric,missing-method}
\alias{num2str,array,missing-method}
\alias{num2str,numeric,numeric-method}
\alias{num2str,array,numeric-method}
\alias{num2str,numeric,character-method}
\alias{num2str,array,character-method}
\title{Numeric to string}
\usage{
num2str(A, format)

\S4method{num2str}{numeric,missing}(A)

\S4method{num2str}{array,missing}(A)

\S4method{num2str}{numeric,numeric}(A, format)

\S4method{num2str}{array,numeric}(A, format)

\S4method{num2str}{numeric,character}(A, format)

\S4method{num2str}{array,character}(A, format)
}
\arguments{
\item{A}{numeric object}

\item{format}{either a number or a string (see \code{fmt} argument of
\code{\link[base:sprintf]{base::sprintf()}}).}
}
\value{
\code{A}, with its format possibly reshaped by \code{format}
}
\description{
Converts a numeric value to character. This is essentially a
wrapper over \code{\link[base:character]{base::as.character()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{num2str(A = numeric, format = missing)}: Converting a vector to character

\item \code{num2str(A = array, format = missing)}: Converting an array to character

\item \code{num2str(A = numeric, format = numeric)}: Rounding a vector, then converting to character

\item \code{num2str(A = array, format = numeric)}: Rounding an arrray, then converting to character

\item \code{num2str(A = numeric, format = character)}: Formatting a vector, then converting to character

\item \code{num2str(A = array, format = character)}: Formatting an array, then converting to character

}}
\examples{
X <- rnorm(10)
num2str(X)
num2str(X, 2)
A <- matrix(runif(4), 2)
num2str(A)
num2str(A, 3)
num2str(pi * 10, "\%e")
}
\author{
Waldir Leoncio
}
