% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialmodifier.R
\name{modif}
\alias{modif}
\title{Apply material editing effect}
\usage{
modif(
  im,
  effect,
  strength,
  max_size = 1024,
  log_epsilon = 1e-04,
  filter_epsilon = 0.01
)
}
\arguments{
\item{im}{An input image.}

\item{effect}{A string naming the effect to apply. Either "gloss", "shine", "spots", "blemish", "rough",
"stain", "shadow", or "aging".}

\item{strength}{A numeric, which controls the strength of the effect. Strength values between 0 and 1 will
reduce a feature, while strength values larger than 1 will boost a feature. A strength value of 1 does nothing.
Negative values are allowed, which will invert a feature.}

\item{max_size}{If the shorter side of the input image is larger than this value (the default is 1024),
input image is resized before applying effects. Because the modif() function is very slow for large-resolution
images, it is useful to limit the image resolution to speed-up the image processing.}

\item{log_epsilon}{Offset for log transformation (default is 0.0001).
Need not to change this value in most cases.}

\item{filter_epsilon}{Epsilon parameter of the Guided filter (default is 0.01).
Need not to change this value in most cases.}
}
\value{
an output image
}
\description{
Apply material editing effect
}
\examples{
\donttest{
plot(modif(face, effect = "shine", strength = 2.5)) # Apply the "shine" effect (make objects shiny)
plot(modif(face, effect = "shine", strength = 0.2)) # Less shiny effect with a parameter less than 1
plot(modif(face, effect = c("shine", "stain"), strength = c(0.2, 3))) # Less shiny and more stain
}
}
