% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matingPlot.R
\name{plotScene}
\alias{plotScene}
\title{graphical visualization of a mating scene object}
\usage{
plotScene(scene, dimension = "auto", opening = NULL, closing = NULL,
  dailyPoints = TRUE, drawQuartiles = TRUE, sub = NULL, N = 9,
  xcoord = "xlab", ycoord = "ylab", pch = 19, quartileWt = 2,
  quartileColor = "gray81", peakColor = "gray27", ...)
}
\arguments{
\item{scene}{a matingScene object}

\item{dimension}{what dimension(s) of the mating scene should be visualized. Possible dimensions are 't' for temporal, 's' for spatial, 'mt' for mating type, and 'auto' (the default). For dimension = 'auto', all dimensions represented in the mating scene object will be plotted.}

\item{opening}{the number of days to adjust the start date displayed for the temporal dimension. Start date defaults to minimum day of year of start date in mating scene object.}

\item{closing}{the number of days to adjust the end date displayed for the temporal dimension. End date defaults to maximum day of year end date in mating scene object.}

\item{dailyPoints}{logical indicating whether daily counts of individuals should be displayed for plots of the temporal dimension}

\item{drawQuartiles}{logical indicating whether vertical lines should be drawn at population peak (the date when the maximum number of individuals were reproductively available) or quartiles}

\item{sub}{a vector containing the ids of individuals to be highlighted in the plots or a character string specifying how to choose individuals to highlight. Possible values are "random" or "all". If NULL, no subset will be identified in the plots.}

\item{N}{a positive number, the number of individuals to sample if \code{sub} = 'random'}

\item{xcoord}{label for x coordinate of spatial dimension plots. If NULL, defaults to 'easting'.}

\item{ycoord}{label for y coordinate of spatial dimension plots. If NULL, defaults to 'northing'.}

\item{pch}{specify point type to be used in plots. Defaults to pch = 19 (filled in circle). If NULL points will be labeled by id.}

\item{quartileWt}{if drawQuartiles = TRUE, specify weight of quartile and peak lines}

\item{quartileColor}{if drawQuartiles = TRUE, specify color of quartile lines, defaults to 'gray81'}

\item{peakColor}{if drawQuartiles = TRUE, specify color of peak lines, defaults to 'gray27'}

\item{...}{standard graphical parameters}
}
\value{
nothing

optional arguments for the plot function
}
\description{
Visualize a mating scene
}
\examples{
pop <- simulateScene()
plotScene(pop)
\dontrun{plotMap(NULL)}


}
\author{
Amy Waananen
}
\seealso{
see \code{\link{plot3DScene}} to visualize multiple dimensions on one plot
}

