/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateLong;
import choco.kernel.memory.trailing.AbstractStoredObject;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.trail.StoredLongTrail;

public final class StoredLong
extends AbstractStoredObject
implements IStateLong {
    protected final StoredLongTrail myTrail;
    private long currentValue;

    public StoredLong(EnvironmentTrailing env) {
        this(env, 0L);
    }

    public StoredLong(EnvironmentTrailing env, long d) {
        super(env);
        this.myTrail = env.getLongTrail();
        this.currentValue = d;
    }

    @Override
    public long get() {
        return this.currentValue;
    }

    @Override
    public void set(long y) {
        if (y != this.currentValue) {
            if (this.worldStamp < this.environment.getWorldIndex()) {
                this.myTrail.savePreviousState(this, this.currentValue, this.worldStamp);
                this.worldStamp = this.environment.getWorldIndex();
            }
            this.currentValue = y;
        }
    }

    @Override
    public long add(long delta) {
        this.set(this.currentValue + delta);
        return this.currentValue;
    }

    public void _set(long y, int wstamp) {
        this.currentValue = y;
        this.worldStamp = wstamp;
    }

    public String toString() {
        return String.valueOf(this.currentValue);
    }
}

