/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.timeWindows;

import choco.cp.solver.constraints.global.tree.filtering.RemovalsAdvisor;
import choco.cp.solver.constraints.global.tree.structure.inputStructure.Node;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.logging.Logger;

public class DirectedPropag {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected boolean debugRem = false;
    protected int nbNodes;
    protected Node[] nodes;
    protected IStateBitSet[] sure;
    protected IStateBitSet[] revSure;
    protected IStateBitSet src;
    protected IStateBitSet sink;
    protected IStateBitSet[] maybe;
    protected IStateBitSet[] revMaybe;
    IStateInt[][] travelTime;
    protected RemovalsAdvisor propagateStruct;

    public DirectedPropag(IStateInt[][] travelTime, VarGraphView graph, Node[] nodes, RemovalsAdvisor propagateStruct) {
        this.travelTime = travelTime;
        this.sure = graph.getSure().getGraph();
        this.revSure = graph.getSure().getRevGraph();
        this.maybe = graph.getGlobal().getGraph();
        this.revMaybe = graph.getGlobal().getGraph();
        this.nbNodes = graph.getNbNodes();
        this.sink = graph.getGlobal().getSinkNodes();
        this.src = graph.getGlobal().getSrcNodes();
        this.propagateStruct = propagateStruct;
        this.nodes = nodes;
    }

    public void applyTWfiltering() throws ContradictionException {
        this.updateInf();
        this.updateSup();
        this.updateByPotentialSucc();
        this.updateByPotentialPred();
    }

    public void applyGraphFiltering() throws ContradictionException {
        for (int i = 0; i < this.nbNodes - 1; ++i) {
            int j = this.maybe[i].nextSetBit(0);
            while (j >= 0) {
                if (this.nodes[i].getTimeWindow().getInf() + this.travelTime[i][j].get() > this.nodes[j].getTimeWindow().getSup()) {
                    if (this.debugRem) {
                        LOGGER.info("-------------------------------------------------------------------");
                        LOGGER.info("Update[applyGraphFiltering] : twPropagation.TWConstraint for nodes " + i);
                        LOGGER.info("\tremove arc (" + i + "," + j + ") from Gmaybe : " + this.nodes[i].getTimeWindow().getInf() + "+" + this.travelTime[i][j] + " > " + this.nodes[j].getTimeWindow().getSup());
                        LOGGER.info("-------------------------------------------------------------------");
                    }
                    int[] arc = new int[]{i, j};
                    this.propagateStruct.addRemoval(arc);
                }
                j = this.maybe[i].nextSetBit(j + 1);
            }
        }
    }

    private void updateInf() throws ContradictionException {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        BitSet reached = new BitSet(this.nbNodes);
        int i = this.src.nextSetBit(0);
        while (i >= 0) {
            if (!reached.get(i)) {
                queue.offer(i);
            }
            i = this.src.nextSetBit(i + 1);
        }
        while (!queue.isEmpty()) {
            i = (Integer)queue.poll();
            reached.set(i, true);
            int j = this.sure[i].nextSetBit(0);
            while (j >= 0) {
                if (!reached.get(j)) {
                    queue.offer(j);
                }
                int newVal = this.nodes[i].getTimeWindow().getInf() + this.travelTime[i][j].get();
                if (this.nodes[j].getTimeWindow().getInf() < newVal) {
                    this.propagateStruct.setMinStart(j, newVal);
                }
                j = this.sure[i].nextSetBit(j + 1);
            }
        }
    }

    private void updateSup() throws ContradictionException {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        BitSet reached = new BitSet(this.nbNodes);
        int i = this.sink.nextSetBit(0);
        while (i >= 0) {
            if (!reached.get(i)) {
                queue.offer(i);
            }
            i = this.sink.nextSetBit(i + 1);
        }
        while (!queue.isEmpty()) {
            int j = (Integer)queue.poll();
            reached.set(j, true);
            int i2 = this.revSure[j].nextSetBit(0);
            while (i2 >= 0) {
                if (!reached.get(i2)) {
                    queue.offer(i2);
                    int newVal = this.nodes[j].getTimeWindow().getSup() - this.travelTime[i2][j].get();
                    if (this.nodes[i2].getTimeWindow().getSup() > newVal) {
                        this.propagateStruct.setMaxStart(i2, newVal);
                    }
                }
                i2 = this.revSure[j].nextSetBit(i2 + 1);
            }
        }
    }

    public void updateByPotentialSucc() throws ContradictionException {
        for (int i = 0; i < this.nbNodes; ++i) {
            if (this.maybe[i].get(i)) continue;
            int newMax = 0;
            boolean update = false;
            int j = this.maybe[i].nextSetBit(0);
            while (j >= 0) {
                int val = this.nodes[j].getTimeWindow().getSup() - this.travelTime[i][j].get();
                if (newMax < val) {
                    update = true;
                    newMax = val;
                }
                j = this.maybe[i].nextSetBit(j + 1);
            }
            if (newMax >= this.nodes[i].getTimeWindow().getSup() || !update) continue;
            if (this.debugRem) {
                LOGGER.info("-------------------------------------------------------------------");
                LOGGER.info("Update[updateByPotentialSucc] : twPropagation.TWConstraint for nodes " + i);
                LOGGER.info("\t max start " + i + " = " + this.nodes[i].getTimeWindow().getSup() + " devient " + newMax);
                LOGGER.info("-------------------------------------------------------------------");
            }
            this.propagateStruct.setMaxStart(i, newMax);
        }
    }

    public void updateByPotentialPred() throws ContradictionException {
        for (int j = 0; j < this.nbNodes; ++j) {
            if (this.nodes[j].getInDegree().getInf() <= 0) continue;
            int newMin = 2000000000;
            boolean update = false;
            int i = this.revMaybe[j].nextSetBit(0);
            while (i >= 0) {
                int val = this.nodes[i].getTimeWindow().getInf() + this.travelTime[i][j].get();
                if (newMin > val) {
                    update = true;
                    newMin = val;
                }
                i = this.revMaybe[j].nextSetBit(i + 1);
            }
            if (newMin <= this.nodes[j].getTimeWindow().getInf() || !update) continue;
            if (this.debugRem) {
                LOGGER.info("-------------------------------------------------------------------");
                LOGGER.info("Update[updateByPotentialPred] : twPropagation.TWConstraint for nodes " + j);
                LOGGER.info("\t min start " + j + " = " + this.nodes[j].getTimeWindow().getInf() + " devient " + newMin);
                LOGGER.info("-------------------------------------------------------------------");
            }
            this.propagateStruct.setMaxStart(j, newMin);
        }
    }
}

