/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistGeqIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistLeqIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistLinearIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.Inbox;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.Outbox;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.SolverException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class IntermediateLayer {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();

    public List lexInFeasible(InternalConstraint ictr, boolean minLex, int d, int k, Obj o) {
        List result = new ArrayList();
        switch (ictr.getIctrID()) {
            case 1: {
                result = this.lexInFeasibleForInbox((Inbox)ictr, minLex, d, k, o);
                break;
            }
            case 2: {
                result = this.lexInFeasibleForOutbox((Outbox)ictr, minLex, k, o);
                break;
            }
            case 3: {
                result = this.lexInFeasibleForAvoidHoles();
                break;
            }
            default: {
                LOGGER.severe("A call to LexFeasible with incorrect ictrID parameter");
            }
        }
        return result;
    }

    public List isFeasible(InternalConstraint ictr, boolean min, int d, int k, Obj o, Point c, Point jump) {
        List result = new ArrayList();
        switch (ictr.getIctrID()) {
            case 1: {
                result = this.isFeasibleForInbox((Inbox)ictr, min, d, k, o, c);
                break;
            }
            case 2: {
                result = this.isFeasibleForOutbox((Outbox)ictr, min, k, o, c);
                break;
            }
            case 3: {
                result = this.isFeasibleForAvoidHoles();
                break;
            }
            case 5: {
                result = ((DistLeqIC)ictr).isFeasible(min, d, k, o, c, jump);
                break;
            }
            case 6: {
                result = ((DistGeqIC)ictr).isFeasible(min, d, k, o, c, jump);
                break;
            }
            case 7: {
                result = ((DistLinearIC)ictr).isFeasible(min, d, k, o, c, jump);
                break;
            }
            default: {
                throw new SolverException("A call to IsFeasible with incorrect ictrID parameter");
            }
        }
        return result;
    }

    public int CardInfeasible(InternalConstraint ictr, int k, Obj o) {
        int result = 0;
        switch (ictr.getIctrID()) {
            case 1: {
                result = this.CardInfeasibleForInbox((Inbox)ictr, k, o);
                break;
            }
            case 2: {
                result = this.CardInfeasibleForOutbox((Outbox)ictr, k, o);
                break;
            }
            case 3: {
                result = this.cardInfeasibleForAvoidHoles();
                break;
            }
            default: {
                LOGGER.severe("A call to CardInfeasible with incorrect ictr parameter");
            }
        }
        return result;
    }

    private List lexInFeasibleForInbox(Inbox ictr, boolean minLex, int d, int k, Obj o) {
        int j;
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        boolean in = true;
        Point p = new Point(k);
        for (j = 0; j < k; ++j) {
            if (minLex) {
                p.setCoord(j, o.getCoord(j).getInf());
            } else {
                p.setCoord(j, o.getCoord(j).getSup());
            }
            if (p.getCoord(j) >= t[j] && p.getCoord(j) <= t[j] + l[j] - 1) continue;
            in = false;
        }
        if (in) {
            for (j = k - 1; j >= 0; --j) {
                int jPrime = (j + d) % k;
                if (!minLex) continue;
                if (t[jPrime] + l[jPrime] <= o.getCoord(jPrime).getSup()) {
                    p.setCoord(jPrime, t[jPrime] + l[jPrime]);
                    result.clear();
                    result.add(0, Boolean.valueOf(true));
                    result.add(1, p);
                    return result;
                }
                if (t[jPrime] - 1 < o.getCoord(jPrime).getInf()) continue;
                p.setCoord(jPrime, t[jPrime] - 1);
                result.clear();
                result.add(0, Boolean.valueOf(true));
                result.add(1, p);
                return result;
            }
            result.clear();
            result.add(0, Boolean.valueOf(false));
            result.add(1, p);
            return result;
        }
        result.clear();
        result.add(0, Boolean.valueOf(true));
        result.add(1, p);
        return result;
    }

    private List lexInFeasibleForOutbox(Outbox ictr, boolean minLex, int k, Obj o) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        Point p = new Point(k);
        for (int j = 0; j < k; ++j) {
            if (o.getCoord(j).getSup() < t[j] || o.getCoord(j).getInf() > t[j] + l[j] - 1) {
                result.clear();
                result.add(0, Boolean.valueOf(false));
                result.add(1, p);
                return result;
            }
            if (minLex) {
                p.setCoord(j, Math.max(t[j], o.getCoord(j).getInf()));
                continue;
            }
            p.setCoord(j, Math.max(t[j] + l[j] - 1, o.getCoord(j).getSup()));
        }
        result.clear();
        result.add(0, Boolean.valueOf(true));
        result.add(1, p);
        return result;
    }

    private List lexInFeasibleForAvoidHoles() {
        return new ArrayList();
    }

    private List isFeasibleForInbox(Inbox ictr, boolean min, int d, int k, Obj o, Point c) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        boolean before = false;
        boolean after = false;
        boolean feasible = false;
        Region f = new Region(k, o.getObjectId());
        for (int j = 0; j < k; ++j) {
            int jPrime = (j + d) % k;
            if (min) {
                f.setMinimumBoundary(jPrime, c.getCoord(jPrime));
                if (c.getCoord(jPrime) < t[jPrime] && !before) {
                    f.setMaximumBoundary(jPrime, t[jPrime] - 1);
                    before = true;
                    continue;
                }
                f.setMaximumBoundary(jPrime, o.getCoord(jPrime).getSup());
                if (c.getCoord(jPrime) <= t[jPrime] + l[jPrime] - 1) continue;
                after = true;
                continue;
            }
            f.setMaximumBoundary(jPrime, c.getCoord(jPrime));
            if (c.getCoord(jPrime) >= t[jPrime]) continue;
            before = true;
        }
        feasible = !before && !after;
        result.clear();
        result.add(0, Boolean.valueOf(feasible));
        result.add(1, f);
        return result;
    }

    private List isFeasibleForOutbox(Outbox ictr, boolean min, int k, Obj o, Point c) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        Region f = new Region(k, o.getObjectId());
        for (int j = 0; j < k; ++j) {
            if (c.getCoord(j) < t[j] || c.getCoord(j) > t[j] + l[j] - 1) {
                result.clear();
                result.add(0, Boolean.valueOf(true));
                result.add(1, f);
                return result;
            }
            if (min) {
                f.setMinimumBoundary(j, c.getCoord(j));
                f.setMaximumBoundary(j, Math.min(o.getCoord(j).getSup(), t[j] + l[j] - 1));
                continue;
            }
            f.setMaximumBoundary(j, c.getCoord(j));
            f.setMinimumBoundary(j, Math.max(o.getCoord(j).getInf(), t[j]));
        }
        result.clear();
        result.add(0, Boolean.valueOf(false));
        result.add(1, f);
        return result;
    }

    private List isFeasibleForAvoidHoles() {
        return new ArrayList();
    }

    private int CardInfeasibleForInbox(Inbox ictr, int k, Obj o) {
        int n = 1;
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        for (int j = 0; j < k; ++j) {
            n *= o.getCoord(j).getSup() - o.getCoord(j).getInf() + 1;
        }
        int m = 1;
        for (int j = 0; j < k; ++j) {
            m *= Math.max(0, Math.min(o.getCoord(j).getSup(), t[j] + l[j] - 1) - Math.max(o.getCoord(j).getInf(), t[j]) + 1);
        }
        return n - m;
    }

    private int CardInfeasibleForOutbox(Outbox ictr, int k, Obj o) {
        int n = 1;
        int[] t = new int[ictr.getT().length];
        t = ictr.getT();
        int[] l = new int[ictr.getL().length];
        l = ictr.getL();
        for (int j = 0; j < k; ++j) {
            n *= Math.min(o.getCoord(j).getSup(), t[j] + l[j] - 1) - Math.max(o.getCoord(j).getInf(), t[j]) + 1;
        }
        return n;
    }

    private int cardInfeasibleForAvoidHoles() {
        return 0;
    }
}

