/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.globalCardConstraint;

import choco.cp.solver.constraints.global.tree.filtering.RemovalsAdvisor;
import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.globalCardConstraint.AbstractBipartFlow;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;

public class GlobalCardinalityNoLoop
extends AbstractBipartFlow {
    protected boolean affiche;
    protected VarGraphView inputGraph;

    public GlobalCardinalityNoLoop(Solver solver, Object[] pack) {
        super(solver, pack);
        this.affiche = (Boolean)pack[2];
        this.minValue = 0;
        this.maxValue = this.nbLeftVertices;
        for (int i = 0; i < this.minFlow.length; ++i) {
            this.minFlow[i] = this.struct.getDegree().getLow()[i];
            this.maxFlow[i] = this.struct.getDegree().getUp()[i];
        }
        this.inputGraph = this.struct.getInputGraph();
    }

    @Override
    public void deleteEdgeAndPublish(int i, int j, RemovalsAdvisor rem) {
        this.deleteMatch(i, j);
        this.graph[i].set(j + this.minValue, false);
        int val = j + this.minValue;
        if (val >= this.graph.length) {
            if (this.inputGraph.getGlobal().getSuccessors(i).get(val)) {
                if (this.affiche) {
                    LOGGER.info("\t" + this.solver.getEnvironment().getWorldIndex() + " --> 1-GCC: suppression de l'arc (" + this.index[i] + "," + val + ")");
                }
                int[] arc = new int[]{this.index[i], val};
                rem.addRemoval(arc);
            }
        } else if (this.inputGraph.getGlobal().getSuccessors(this.index[i]).get(val)) {
            if (this.affiche) {
                LOGGER.info("\t" + this.solver.getEnvironment().getWorldIndex() + " --> 2-GCC: suppression de l'arc (" + this.index[i] + "," + val + ")");
            }
            int[] arc = new int[]{this.index[i], val};
            rem.addRemoval(arc);
        }
    }

    public boolean applyGCC(RemovalsAdvisor rem) throws ContradictionException {
        for (int i = 0; i < this.nbRightVertices; ++i) {
            int nbUsed = 0;
            for (int j = 0; j < this.nbLeftVertices; ++j) {
                if (!this.graph[j].get(i)) continue;
                ++nbUsed;
            }
            if (nbUsed >= this.minFlow[i] && this.struct.getDegree().isCompatibleDegree()) continue;
            if (this.affiche) {
                LOGGER.info("nbUsed = " + nbUsed + " VS minFlow[" + i + "] = " + this.minFlow[i] + " ==> ECHEC");
            }
            return false;
        }
        this.propagate(rem);
        return this.isFeasible;
    }
}

