/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.ISolutionPool;
import choco.kernel.solver.search.NoSolutionPool;
import choco.kernel.solver.search.measure.ISolutionMeasures;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractSearchStrategy
implements ISolutionMeasures {
    protected static final Logger LOGGER = ChocoLogging.getSearchLogger();
    public final Solver solver;
    protected ISolutionPool solutionPool;
    protected int nbSolutions = 0;

    public AbstractSearchStrategy(Solver solver) {
        this.solver = solver;
    }

    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public final boolean existsSolution() {
        return this.nbSolutions > 0;
    }

    @Override
    public final int getSolutionCount() {
        return this.nbSolutions;
    }

    public final ISolutionPool getSolutionPool() {
        return this.solutionPool;
    }

    public final void setSolutionPool(ISolutionPool solutionPool) {
        if (solutionPool == null) {
            this.solutionPool = NoSolutionPool.SINGLETON;
        }
        this.solutionPool = solutionPool;
    }

    public final void resetSolutions() {
        this.solutionPool.clear();
        this.nbSolutions = 0;
        this.solver.setFeasible(null);
    }

    public void recordSolution() {
        this.solver.setFeasible(Boolean.TRUE);
        ++this.nbSolutions;
        this.solutionPool.recordSolution(this.solver);
    }

    public void writeSolution(Solution sol) {
        sol.setSolver(this.solver);
        sol.recordSolutionCount(this.nbSolutions);
        sol.recordIntValues();
        sol.recordSetValues();
        sol.recordRealValues();
    }

    public void restoreBestSolution() {
        this.solver.restoreSolution(this.solutionPool.getBestSolution());
    }

    public final List<Solution> getStoredSolutions() {
        return this.solutionPool.asList();
    }
}

