% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_figures.R
\name{dot}
\alias{dot}
\title{Coordinates of a dot}
\usage{
dot(
  size.x = 2,
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  lwd = 3,
  lty = 1,
  shd = "black",
  vis = 1
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 2}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line).}

\item{shd}{character, define the shading of the figure. Default is black}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}
}
\value{
Return the coordinates for drawing a dot
}
\description{
Define the coordinates for drawing a dot
}
\examples{
# return the default coordinates for drawing a dot
dot()

# change the shade of the dot

dot(shd = "grey")
}
