% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{vline}
\alias{vline}
\alias{hline}
\alias{diagline}
\alias{diagline_inv}
\title{Coordinates of lines}
\usage{
vline(
  size.x = sqrt(square()$size.x[[1]]^2/2),
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  lty = 1,
  lwd = 3,
  vis = 1
)

hline(
  size.x = sqrt(square()$size.x[[1]]^2/2),
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  lty = 1,
  lwd = 3,
  vis = 1
)

diagline(
  size.x = list(sqrt(square()$size.x[[1]]^2/2)),
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  lty = 1,
  lwd = 3,
  rotation = pi - pi/4,
  vis = 1
)

diagline_inv(
  size.x = sqrt(square()$size.x[[1]]^2/2),
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  lty = 1,
  lwd = 3,
  rotation = pi + pi/4,
  vis = 1
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is sqrt(square()$ size.x[[1]]^2 /2)}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x.}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line).}

\item{lwd}{integer, define the line width of the figure. Default is 3.}

\item{vis}{integer, define the visibility of the figure (default is 1, visible)}

\item{rotation}{define the rotation of the line}
}
\value{
Return the coordinates for drawing a vertical line

Return the coordinates for drawing an horizontal line

Return the coordinates for drawing the main diagonal line

Return the coordinates for drawing the inverse diagonal line
}
\description{
Define the coordinates for drawing lines
}
\details{
vline() Define the coordinates for drawing a vertical line
}
\section{Functions}{
\itemize{
\item \code{hline()}: description Coordinates of an horizontal line

Define the coordinates for drawing an horizontal line

\item \code{diagline()}: Coordinates of the main diagonal line

Define the coordinates for drawing the main diagonal line

\item \code{diagline_inv()}: Coordinates of the inverse diagonal line

Define the coordinates for drawing the inverse diagonal line

}}
\examples{
# default coordinates of a vertical line
vline()
# draw a vertical line with different lty
draw(vline(lty = 2))
# default coordinates of an horizontal line
hline()
# draw a vertical line with different lty
draw(hline(lty = 2))
# default coordinates of the main diagonal line
diagline()
# draw the main diagonal line with different lty
draw(diagline(lty = 2))
# default coordinates of the inverse diagonal line
diagline_inv()
# draw the inverse diagonal line with different lty
draw(diagline_inv(lty = 2))
}
