% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct.R
\name{construct}
\alias{construct}
\title{Construct the results of the analysis}
\usage{
construct(data, ..., na.rm = TRUE)
}
\arguments{
\item{data}{The blueprint data object.}

\item{...}{Additional args.}

\item{na.rm}{Whether to remove missing values.}
}
\value{
Uses the blueprint to construct the results of the statistical
analysis. Outputs a \link[tibble:tibble-package]{tibble}.
}
\description{
Construct the results of the analysis
}
\examples{

design(iris, 'cor') \%>\%
 add_settings() \%>\%
 add_variables('xvars', c('Sepal.Length', 'Sepal.Width')) \%>\%
 construct()

design(iris, 't.test') \%>\%
 add_settings() \%>\%
 add_variables('yvars', c('Sepal.Length', 'Sepal.Width')) \%>\%
 add_variables('xvars', c('Petal.Length', 'Petal.Width')) \%>\%
 construct()

design(iris, 'glm') \%>\%
 add_settings() \%>\%
 add_variables('yvars', c('Sepal.Length', 'Sepal.Width')) \%>\%
 add_variables('xvars', c('Petal.Length', 'Petal.Width')) \%>\%
 construct()

design(iris, 'gee') \%>\%
 add_settings('Species') \%>\%
 add_variables('yvars', c('Sepal.Length', 'Sepal.Width')) \%>\%
 add_variables('xvars', c('Petal.Length', 'Petal.Width')) \%>\%
 construct()

design(iris, 'pls') \%>\%
 add_settings() \%>\%
 add_variables('yvars', c('Sepal.Length', 'Sepal.Width')) \%>\%
 add_variables('xvars', c('Petal.Length', 'Petal.Width')) \%>\%
 construct()

}
