% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix_utils.R
\name{get_states_mat}
\alias{get_states_mat}
\title{Get state transition patterns from MarkovFit object}
\usage{
get_states_mat(object, check = TRUE)
}
\arguments{
\item{object}{\code{\link{MarkovMix}} object.}

\item{check}{Logical (1L) indicating whether to check \code{object}
at the beginning.}
}
\value{
A matrix indicating the state transition patterns.
}
\description{
\code{get_states_mat} gets state transition patterns from \code{\link{MarkovMix}} object.
The number of columns is the order of the (mixture of) Markov chain(s) plus 1 (the destination state).
Each column is arranged in the ascending order of the states.
The last column serves as the destination state and iterates the fastest.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the class.}
}
}
\examples{
# Load example MarkovMix object
data("markov_mix_ex")

# Derive state transition patterns
get_states_mat(markov_mix_ex)

# Derive probability matrices
get_prob(markov_mix_ex)

# Derive component priors
get_prior(markov_mix_ex)

# Combine state transition patterns and their probabilities
cbind(
  as.data.frame(get_states_mat(markov_mix_ex)),
  as.data.frame(get_prob(markov_mix_ex))
)
}
\seealso{
Other MarkovMix utilities: 
\code{\link{get_prior}()},
\code{\link{get_prob}()},
\code{\link{restate}()}
}
\author{
Xiurui Zhu
}
\concept{MarkovMix utilities}
