% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_probabilistic.R
\name{is.accessible}
\alias{is.accessible}
\title{Verify if a state j is reachable from state i.}
\usage{
is.accessible(object, from, to)
}
\arguments{
\item{object}{A \code{markovchain} object.}

\item{from}{The name of state "i" (beginning state).}

\item{to}{The name of state "j" (ending state).}
}
\value{
A boolean value.
}
\description{
This function verifies if a state is reachable from another, i.e., 
             if exists a path that leads to state j leaving from state i with 
             positive probability
}
\details{
It wraps an internal function named \code{.commStatesFinder}.
}
\examples{
statesNames <- c("a", "b", "c")
markovB <- new("markovchain", states = statesNames, 
               transitionMatrix = matrix(c(0.2, 0.5, 0.3,
                                             0,   1,   0,
                                           0.1, 0.8, 0.1), nrow = 3, byrow = TRUE, 
                                         dimnames = list(statesNames, statesNames)
                                        )
               )
is.accessible(markovB, "a", "c")
}
\references{
James Montgomery, University of Madison
}
\seealso{
\code{is.irreducible}
}
\author{
Giorgio Spedicato
}
