% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_functions4Fitting.R
\name{rmarkovchain}
\alias{rmarkovchain}
\title{Function to generate a sequence of states from homogeneous or non-homogeneous Markov chains.}
\usage{
rmarkovchain(n, object, what = "data.frame", useRCpp = TRUE,
  parallel = FALSE, num.cores = NULL, ...)
}
\arguments{
\item{n}{Sample size}

\item{object}{Either a \code{markovchain} or a \code{markovchainList} object}

\item{what}{It specifies whether either a \code{data.frame} or a \code{matrix} 
(each rows represent a simulation) or a \code{list} is returned.}

\item{useRCpp}{Boolean. Should RCpp fast implementation being used? Default is yes.}

\item{parallel}{Boolean. Should parallel implementation being used? Default is yes.}

\item{num.cores}{Number of Cores to be used}

\item{...}{additional parameters passed to the internal sampler}
}
\value{
Character Vector, data.frame, list or matrix
}
\description{
Provided any \code{markovchain} or \code{markovchainList} objects, it returns a sequence of 
states coming from the underlying stationary distribution.
}
\details{
When a homogeneous process is assumed (\code{markovchain} object) a sequence is 
sampled of size n. When an non - homogeneous process is assumed,
n samples are taken but the process is assumed to last from the begin to the end of the 
non-homogeneous markov process.
}
\note{
Check the type of input
}
\examples{
# define the markovchain object
statesNames <- c("a", "b", "c")
mcB <- new("markovchain", states = statesNames, 
   transitionMatrix = matrix(c(0.2, 0.5, 0.3, 0, 0.2, 0.8, 0.1, 0.8, 0.1), 
   nrow = 3, byrow = TRUE, dimnames = list(statesNames, statesNames)))

# show the sequence
outs <- rmarkovchain(n = 100, object = mcB, what = "list")


#define markovchainList object
statesNames <- c("a", "b", "c")
mcA <- new("markovchain", states = statesNames, transitionMatrix = 
   matrix(c(0.2, 0.5, 0.3, 0, 0.2, 0.8, 0.1, 0.8, 0.1), nrow = 3, 
   byrow = TRUE, dimnames = list(statesNames, statesNames)))
mcB <- new("markovchain", states = statesNames, transitionMatrix = 
   matrix(c(0.2, 0.5, 0.3, 0, 0.2, 0.8, 0.1, 0.8, 0.1), nrow = 3, 
   byrow = TRUE, dimnames = list(statesNames, statesNames)))
mcC <- new("markovchain", states = statesNames, transitionMatrix = 
   matrix(c(0.2, 0.5, 0.3, 0, 0.2, 0.8, 0.1, 0.8, 0.1), nrow = 3, 
   byrow = TRUE, dimnames = list(statesNames, statesNames)))
mclist <- new("markovchainList", markovchains = list(mcA, mcB, mcC)) 

# show the list of sequence
rmarkovchain(100, mclist, "list")
     
}
\author{
Giorgio Spedicato
}
\references{
A First Course in Probability (8th Edition), Sheldon Ross, Prentice Hall 2010
}
\seealso{
\code{\link{markovchainFit}}
}

