% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_simulation.R
\name{market_simulation}
\alias{market_simulation}
\alias{simulate_data}
\alias{simulate_data,ANY-method}
\alias{simulate_model}
\alias{simulate_model,ANY-method}
\title{Market model simulation}
\usage{
simulate_data(
  model_type_string,
  nobs = NA_integer_,
  tobs = NA_integer_,
  alpha_d = NA_real_,
  beta_d0 = NA_real_,
  beta_d = NA_real_,
  eta_d = NA_real_,
  alpha_s = NA_real_,
  beta_s0 = NA_real_,
  beta_s = NA_real_,
  eta_s = NA_real_,
  gamma = NA_real_,
  beta_p0 = NA_real_,
  beta_p = NA_real_,
  sigma_d = 1,
  sigma_s = 1,
  sigma_p = 1,
  rho_ds = 0,
  rho_dp = 0,
  rho_sp = 0,
  seed = NA_integer_,
  price_generator = function(n) stats::rnorm(n = n),
  control_generator = function(n) stats::rnorm(n = n),
  verbose = 0
)

\S4method{simulate_data}{ANY}(
  model_type_string,
  nobs = NA_integer_,
  tobs = NA_integer_,
  alpha_d = NA_real_,
  beta_d0 = NA_real_,
  beta_d = NA_real_,
  eta_d = NA_real_,
  alpha_s = NA_real_,
  beta_s0 = NA_real_,
  beta_s = NA_real_,
  eta_s = NA_real_,
  gamma = NA_real_,
  beta_p0 = NA_real_,
  beta_p = NA_real_,
  sigma_d = 1,
  sigma_s = 1,
  sigma_p = 1,
  rho_ds = 0,
  rho_dp = 0,
  rho_sp = 0,
  seed = NA_integer_,
  price_generator = function(n) stats::rnorm(n = n),
  control_generator = function(n) stats::rnorm(n = n),
  verbose = 0
)

simulate_model(
  model_type_string,
  simulation_parameters,
  seed = NA,
  verbose = 0,
  correlated_shocks = TRUE
)

\S4method{simulate_model}{ANY}(
  model_type_string,
  simulation_parameters,
  seed = NA,
  verbose = 0,
  correlated_shocks = TRUE
)
}
\arguments{
\item{model_type_string}{Model type. It should be among \code{equilibrium_model},
\code{diseq_basic}, \code{diseq_directional},
\code{diseq_deterministic_adjustment}, and \code{diseq_stochastic_adjustment}.}

\item{nobs}{Number of simulated entities.}

\item{tobs}{Number of simulated dates.}

\item{alpha_d}{Price coefficient of demand.}

\item{beta_d0}{Constant coefficient of demand.}

\item{beta_d}{Coefficients of exclusive demand controls.}

\item{eta_d}{Demand coefficients of common controls.}

\item{alpha_s}{Price coefficient of supply.}

\item{beta_s0}{Constant coefficient of supply.}

\item{beta_s}{Coefficients of exclusive supply controls.}

\item{eta_s}{Supply coefficients of common controls.}

\item{gamma}{Price equation's stability factor.}

\item{beta_p0}{Price equation's constant coefficient.}

\item{beta_p}{Price equation's control coefficients.}

\item{sigma_d}{Demand shock's standard deviation.}

\item{sigma_s}{Supply shock's standard deviation.}

\item{sigma_p}{Price equation shock's standard deviation.}

\item{rho_ds}{Demand and supply shocks' correlation coefficient.}

\item{rho_dp}{Demand and price shocks' correlation coefficient.}

\item{rho_sp}{Supply and price shocks' correlation coefficient.}

\item{seed}{Pseudo random number generator seed.}

\item{price_generator}{Pseudo random number generator callback for prices. The
default generator is \eqn{N(2.5, 0.25)}.}

\item{control_generator}{Pseudo random number generator callback for non-price
controls. The default generator is \eqn{N(2.5, 0.25)}.}

\item{verbose}{Verbosity level.}

\item{simulation_parameters}{List of parameters used in model simulation. See the
\code{\link{simulate_data}} function for details.}

\item{correlated_shocks}{Should the model be estimated using correlated shocks?}
}
\value{
\strong{\code{simulate_data}:} The simulated data.

\strong{\code{simulate_model}:} The simulated model.
}
\description{
Market data and model simulation functionality based on the data
generating process induced by the market model specifications.

\subsection{\code{simulate_data}}{
Returns a data frame with simulated data from a generating process that
matches the passed model string. By default, the simulated observations of the
controls are drawn from a normal distribution.
}

\subsection{\code{simulate_model}}{
Simulates a data frame based on the generating process of the passed model
and uses it to initialize a model object. Data are simulated using the
\code{\link{simulate_data}} function.
}
}
\section{Functions}{
\itemize{
\item \code{simulate_data}: Simulate model data.

\item \code{simulate_model}: Simulate model.
}}

