% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.crm.r
\name{predict.crm}
\alias{predict.crm}
\title{Compute estimates of real parameters}
\usage{
\method{predict}{crm}(object,newdata=NULL,ddl=NULL,parameter=NULL,unique=TRUE,
                   vcv=FALSE,se=FALSE,chat=1,subset=NULL,select=NULL,
                   real.ids=NULL,merge=FALSE,...)
}
\arguments{
\item{object}{model object;}

\item{newdata}{a dataframe for crm}

\item{ddl}{list of dataframes for design data}

\item{parameter}{name of real parameter to be computed (eg "Phi")}

\item{unique}{TRUE if only unique values should be returned}

\item{vcv}{logical; if TRUE, computes and returns v-c matrix of real estimates}

\item{se}{logical; if TRUE, computes std errors and conf itervals of real estimates}

\item{chat}{over-dispersion value}

\item{subset}{logical expression using fields in real dataframe}

\item{select}{character vector of field names in real that you want to include}

\item{real.ids}{animal ids passed to TMB code for computation of real parameter values}

\item{merge}{default FALSE but if TRUE, the ddl for the parameter is merged (cbind) to the estimates}

\item{...}{generic arguments not used here}
}
\value{
A data frame (\code{real}) is returned if \code{vcv=FALSE};
otherwise, a list is returned also containing vcv.real: \item{real}{ data
frame containing estimates, and if vcv=TRUE it also contains
standard errors and confidence intervals} \item{vcv.real}{variance-covariance matrix of
real estimates}
}
\description{
Computes real estimates and their var-cov for a particular subset of 
parameters. The argument newdata may not work with all models. A better approach to 
compute real estimates for a subset of values or a new set of values is to specify a limited 
range of the values in ddl for each parameter. Make sure to include a complete set of values that spans
the factor levels and individual covariates used in the formulas for the model object or you will receive an
error that the number of columns in the design matrix does not match the number of beta parameters.  You cannot 
change the levels of any factor variable or modify the design data in anyway that changes the design matrix.
}
\examples{
data(dipper)
dipper.proc=process.data(dipper,model="cjs",begin.time=1)
dipper.ddl=make.design.data(dipper.proc)
mod.Phisex.pdot=crm(dipper.proc,dipper.ddl,
   model.parameters=list(Phi=list(formula=~sex+time),p=list(formula=~1)),hessian=TRUE)
xx=predict(mod.Phisex.pdot,ddl=dipper.ddl)
xx
xx=predict(mod.Phisex.pdot,newdata=dipper[c(1,23),],vcv=TRUE)
xx
}
\author{
Jeff Laake
}
\keyword{utility}
