% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{mark}
\alias{mark}
\alias{mark_html}
\alias{mark_latex}
\title{Render Markdown to an output format}
\usage{
mark(
  file = NULL,
  output = NULL,
  text = NULL,
  format = c("html", "latex"),
  options = NULL,
  template = FALSE,
  meta = list(),
  ...
)

mark_html(..., options = NULL, template = TRUE, meta = list())

mark_latex(..., template = TRUE)
}
\arguments{
\item{file}{Path to an input file. If not provided, it is presumed that the
\code{text} argument will be used instead. This argument can also take a
character vector of Markdown text directly. To avoid ambiguity in the
latter case, a single character string input will be treated as a file only
when the file exists or it has a file extension. If a string happens to
have a \dQuote{file extension} and should be treated as Markdown text
instead, wrap it in \code{I()}.}

\item{output}{Output file path. If not character, the results will be
returned as a character vector.}

\item{text}{A character vector of the Markdown text. By default, it is read
from \code{file}.}

\item{format}{An output format supported by \pkg{commonmark}, e.g.,
\code{'html'}, \code{'man'}, and \code{'text'}, etc. See the
\code{\link[commonmark:commonmark]{markdown_*}} renderers in
\pkg{commonmark}.}

\item{options}{Options to be passed to the renderer. See
\code{\link{markdown_options}()} for all possible options. This argument
can take either a character vector of the form \code{"+option1
option2-option3"} (use \code{+} or a space to enable an option, and
\code{-} to disable an option), or a list of the form \code{list(option1 =
value1, option2 = value2, ...)}. A string \code{"+option1"} is equivalent
to \code{list(option1 = TRUE)}, and \code{"-option2"} means
\code{list(option2 = FALSE)}. Options that do not take logical values must
be specified via a list, e.g., \code{list(width = 30)}.}

\item{template}{Path to a template file. The default value is
\code{getOption('markdown.FORMAT.template',
markdown:::pkg_file('resources', 'markdown.FORMAT'))} where \code{FORMAT}
is the output format name (\code{html} or \code{latex}). It can also take a
logical value: \code{TRUE} means to use the default template, and
\code{FALSE} means to generate only a fragment without using any template.}

\item{meta}{A named list of metadata. Elements in the metadata will be used
to fill out the template by their names and values, e.g., \code{list(title
= ...)} will replace the \code{$title$} variable in the template. See the
\sQuote{Details} section for supported variables.}

\item{...}{Arguments to be passed to \code{mark()}. For \code{mark_html()},
also additional arguments for backward-compatibility with previous versions
of \pkg{markdown}. These are no longer recommended. For example, the
\code{stylesheet} argument should be replaced by the \code{css} variable in
\code{meta}, and the \code{fragment.only = TRUE} argument should be
specified via \code{options = '-standalone'} instead.}
}
\value{
Invisible \code{NULL} when output is to a file, otherwise a character
  vector of the rendered output.
}
\description{
Render Markdown to an output format via the \pkg{commonmark} package. The
function \code{mark_html()} is a shorthand of \code{mark(format = 'html')},
and \code{mark_latex()} is a shorthand of \code{mark(format = 'latex')}.
}
\details{
Supported variables in metadata for both HTML and HTML templates (the string
\code{FORMAT} below is the output format name, i.e., \code{html} or
\code{latex}):

\describe{

\item{\code{header-includes}, \code{include-before},
\code{include-after}}{Either a vector of code (HTML/LaTeX) or a code file to
be included in the header, before the body, or after the body of the output.
For \code{header-include}, the default value is taken from
\code{getOption('markdown.FORMAT.header')} if not provided in \code{meta}.}

\item{\code{title}}{The document title.}

}

Variables for the HTML template:

\describe{

\item{\code{css}}{Either a vector of CSS code or a file containing CSS to be
included in the output. The default value is
\code{getOption('markdown.html.css', markdown:::pkg_file('resources',
'markdown.css'))}, i.e., it can be set via the global option
\code{markdown.html.css}.}

\item{\code{highlight}}{JavaScript code for syntax-highlighting code blocks.
By default, the highlight.js library is used.}

\item{\code{math}}{JavaScript code for rendering LaTeX math. By default,
MathJax is used.}

}

Variables for the LaTeX template:

\describe{

\item{\code{classoption}}{A string containing options for the document
class.}

\item{\code{documentclass}}{The document class (by default,
\code{'article'}).}

}

Note that you can use either underscores or hyphens in the variable names.
Underscores will be normalized to hyphens internally, e.g.,
\code{header_includes} will be converted to \code{header-includes}. This
means if you use a custom template, you must use hyphens instead of
underscores as separators in variable names in the template.
}
\examples{
library(markdown)
mark(c("Hello _World_!", "", "Welcome to **markdown**."))
# a few corner cases
mark(character(0))
mark("")
# if input looks like file but should be treated as text, use I()
mark(I("This is *not* a file.md"))
# that's equivalent to
mark(text = "This is *not* a file.md")

mark_html("Hello _World_!", options = "-standalone")
# write HTML to an output file
mark_html("_Hello_, **World**!", output = tempfile())

mark_latex("Hello _World_!", template = FALSE)
}
\seealso{
The spec of GitHub Flavored Markdown:
  \url{https://github.github.com/gfm/}
}
