% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcing.R
\name{sourcing}
\alias{sourcing}
\alias{ksource}
\alias{try_source}
\alias{try_ksource}
\title{Sourcing extensions}
\usage{
ksource(file, ..., quiet = TRUE, cd = FALSE, env = parent.frame())

try_source(file, cd = FALSE, ...)

try_ksource(file, ...)
}
\arguments{
\item{file}{An R or Rmd file.}

\item{...}{Additional arguments passed to \code{\link[base:source]{base::source()}}}

\item{quiet}{Logical; Determines whether to apply silence to \code{\link[knitr:knit]{knitr::purl()}}}

\item{cd}{Logical; if TRUE, the R working directory is temporarily
changed to the directory containing file for evaluating}

\item{env}{An environment determining where the parsed expressions are
evaluated}
}
\value{
\itemize{
\item \code{ksource()}: Invisibly, the result of calling \code{source()} on the \code{.R} file conversion of \code{file}
\item \code{try_source()}, \code{try_ksource()}: attempts of \code{source()} and \code{ksource()} but converts errors to warnings
}
}
\description{
Functions for extending sourcing features
}
\details{
\code{try_source()} will output an error message rather than completely preventing
the execution.
This can be useful for when a script calls on multiple, independent files to
be sourced and a single failure shouldn't prevent the entire run to fail as
well.
}
