% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframes.R
\name{t_df}
\alias{t_df}
\title{Data frame transpose}
\usage{
t_df(x, id = NULL)
}
\arguments{
\item{x}{A data.frame}

\item{id}{No longer used}
}
\value{
A transposed \code{data.frame} with columns (\code{"colname"}, \code{"row_1"}, ...,
for each row in \code{x}.
}
\description{
This transposes a data.frame with \code{t()} but transforms back into a data.frame
with column and row names cleaned up.  Because the data types may be mixed
and reduced to characters, this may only be useful for a visual viewing of
the data.frame.
}
\details{
Transposes a data.frame as a data.frame
}
\examples{
x <- data.frame(col_a = Sys.Date() + 1:5, col_b = letters[1:5], col_c = 1:5)
t_df(x)
}
