% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanTLCommunity.R
\name{meanTLCommunity}
\alias{meanTLCommunity}
\title{Calculates the Mean Trophic Level of the community}
\usage{
meanTLCommunity(X, TL.table, metric = "BIOMASS", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{BIOMASS} is the corresponding biomass (stratified
and corrected for catchability as required).}

\item{TL.table}{A dataframe with columns \code{SPECIES} and the corresponding
\code{TL} (trophic level). Entries in the \code{SPECIES} column should be
the unique values of species codes in \code{X} (or a subset thereof). Other
columns in \code{TL.table} are ignored.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with 3 columns. \code{ID}, \code{YEAR}, and
 \code{MeanTLCommunity}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 value is assigned \code{NA}.
}
\description{
This function calculates the Mean Trophic Level of the community
 weighted by biomass for \eqn{j} areas and \eqn{i} years.
}
\details{
Mean trophic level (TL): \deqn{TL = \Sigma (TL_i*B_i)/\Sigma B_i}
 \eqn{TL_i} is trophic level of species \eqn{i}, and \eqn{B_i} is the biomass
 of species \eqn{i}.

 This indicator is based on trophic levels of all species with available
 biomass time series, weighted by annual species-specific biomass, to reflect
 the structure of the community (Christensen, 1998).
}
\examples{
# Compile data
data(X)
data(species.info)

# Calculate indicator
meanTLCommunity(X, TL.table = species.info, metric = "BIOMASS", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Christensen V. 1998. Fishery-induced changes in a marine ecosystem: insight
 from models of the Gulf of Thailand. J. Fish Bio. 53:128-142. Article No.
 jb980809

 Shannon L, Coll M, Bundy A, Gascuel D, Heymans JJ, Kleisner K, Lynam CP,
 Piroddi C, Tam J, Travers-Trolet M, Shin Y. 2014. Trophic level-based
 indicators to track fishing impacts across marine ecosystems. Mar. Ecol.
 Prog. Ser. 512, 115–140.
}
\seealso{
Other ecosystem structure and function indicators: \code{\link{allStructure}},
  \code{\link{biomassRatio}},
  \code{\link{communityCondition}},
  \code{\link{largeFishIndicator}},
  \code{\link{largeSpeciesIndicator}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{ecosystem structure and function indicators}
