% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferences.R
\name{inferences}
\alias{inferences}
\title{(EXPERIMENTAL) Bootstrap and Simulation-Based Inference}
\usage{
inferences(x, method, R = 1000, conf_type = "perc", ...)
}
\arguments{
\item{x}{Object produced by one of the core \code{marginaleffects} functions.}

\item{method}{String
\itemize{
\item "delta": delta method standard errors
\item "boot" package
\item "fwb": fractional weighted bootstrap
\item "rsample" package
\item "simulation" from a multivariate normal distribution (Krinsky & Robb, 1986)
}}

\item{R}{Number of resamples or simulations.}

\item{conf_type}{String: type of bootstrap interval to construct.
\itemize{
\item \code{boot}: "perc", "norm", "basic", or "bca"
\item \code{fwb}: "perc", "norm", "basic", "bc", or "bca"
\item \code{rsample}: "perc" or "bca"
\item \code{simulation}: argument ignored.
}}

\item{...}{\itemize{
\item If \code{method="boot"}, additional arguments are passed to \code{boot::boot()}.
\item If \code{method="fwb"}, additional arguments are passed to \code{fwb::fwb()}.
\item If \code{method="rsample"}, additional arguments are passed to \code{rsample::bootstraps()}.
\item If \code{method="simulation"}, additional arguments are ignored.
}}
}
\value{
A \code{marginaleffects} object with simulation or bootstrap resamples and objects attached.
}
\description{
Warning: This function is experimental. It may be renamed, the user interface may change, or the functionality may migrate to arguments in other \code{marginaleffects} functions.

Apply this function to a \code{marginaleffects} object to change the inferential method used to compute uncertainty estimates.
}
\details{
When \code{method="simulation"}, we conduct simulation-based inference following the method discussed in Krinsky & Robb (1986):
\enumerate{
\item Draw \code{R} sets of simulated coefficients from a multivariate normal distribution with mean equal to the original model's estimated coefficients and variance equal to the model's variance-covariance matrix (classical, "HC3", or other).
\item Use the \code{R} sets of coefficients to compute \code{R} sets of estimands: predictions, comparisons, or slopes.
\item Take quantiles of the resulting distribution of estimands to obtain a confidence interval and the standard deviation of simulated estimates to estimate the standard error.
}

When \code{method="fwb"}, drawn weights are supplied to the model fitting function's \code{weights} argument; if the model doesn't accept non-integer weights, this method should not be used. If weights were included in the original model fit, they are extracted by \code{\link[=weights]{weights()}} and multiplied by the drawn weights. These weights are supplied to the \code{wts} argument of the estimation function (e.g., \code{comparisons()}).
}
\section{References}{


Krinsky, I., and A. L. Robb. 1986. “On Approximating the Statistical Properties of Elasticities.” Review of Economics and Statistics 68 (4): 715–9.

King, Gary, Michael Tomz, and Jason Wittenberg. "Making the most of statistical analyses: Improving interpretation and presentation." American journal of political science (2000): 347-361

Dowd, Bryan E., William H. Greene, and Edward C. Norton. "Computation of standard errors." Health services research 49.2 (2014): 731-750.
}

\examples{
\dontrun{
library(marginaleffects)
library(magrittr)
set.seed(1024)
mod <- lm(Sepal.Length ~ Sepal.Width * Species, data = iris)

avg_predictions(mod, by = "Species") \%>\%
  inferences(method = "boot")

slopes(mod) \%>\%
  inferences(method = "simulation") \%>\%
  head()

avg_slopes(mod, by = "Species") \%>\%
  inferences(method = "fwb") \%>\%
  posterior_draws("rvar") \%>\%
  data.frame()
}
}
