% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vcov.R, R/methods_MCMCglmm.R,
%   R/methods_afex.R, R/methods_aod.R, R/methods_biglm.R, R/methods_brms.R,
%   R/methods_dbarts.R, R/methods_gamlss.R, R/methods_glmmTMB.R,
%   R/methods_mhurdle.R, R/methods_mlr3.R, R/methods_rms.R, R/methods_rstpm2.R,
%   R/methods_scam.R, R/methods_systemfit.R, R/methods_tidymodels.R
\name{get_vcov}
\alias{get_vcov}
\alias{get_vcov.default}
\alias{get_vcov.MCMCglmm}
\alias{get_vcov.afex_aov}
\alias{get_vcov.glimML}
\alias{get_vcov.biglm}
\alias{get_vcov.brmsfit}
\alias{get_vcov.bart}
\alias{get_vcov.gamlss}
\alias{get_vcov.glmmTMB}
\alias{get_vcov.mhurdle}
\alias{get_vcov.Learner}
\alias{get_vcov.orm}
\alias{get_vcov.stpm2}
\alias{get_vcov.pstpm2}
\alias{get_vcov.gsm}
\alias{get_vcov.aft}
\alias{get_vcov.scam}
\alias{get_vcov.systemfit}
\alias{get_predict.systemfit}
\alias{get_vcov.model_fit}
\alias{get_vcov.workflow}
\title{Get a named variance-covariance matrix from a model object}
\usage{
get_vcov(model, ...)

\method{get_vcov}{default}(model, vcov = NULL, ...)

\method{get_vcov}{MCMCglmm}(model, vcov = NULL, ...)

\method{get_vcov}{afex_aov}(model, vcov = NULL, ...)

\method{get_vcov}{glimML}(model, vcov = NULL, ...)

\method{get_vcov}{biglm}(model, vcov = NULL, ...)

\method{get_vcov}{brmsfit}(model, vcov = NULL, ...)

\method{get_vcov}{bart}(model, vcov = NULL, ...)

\method{get_vcov}{gamlss}(model, ...)

\method{get_vcov}{glmmTMB}(model, vcov, ...)

\method{get_vcov}{mhurdle}(model, vcov = NULL, ...)

\method{get_vcov}{Learner}(model, ...)

\method{get_vcov}{orm}(model, vcov = NULL, ...)

\method{get_vcov}{stpm2}(model, ...)

\method{get_vcov}{pstpm2}(model, ...)

\method{get_vcov}{gsm}(model, ...)

\method{get_vcov}{aft}(model, ...)

\method{get_vcov}{scam}(model, vcov = NULL, ...)

\method{get_vcov}{systemfit}(model, ...)

\method{get_predict}{systemfit}(model, newdata = NULL, type = NULL, ...)

\method{get_vcov}{model_fit}(model, vcov, type = NULL, ...)

\method{get_vcov}{workflow}(model, vcov, type = NULL, ...)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?slopes} documentation for a non-exhaustive list of available
arguments.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
\item "rsample", "boot", "fwb", and "simulation" are passed to the \code{method} argument of the \code{inferences()} function. To customize the bootstrap or simulation process, call \code{inferences()} directly.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{newdata}{Grid of predictor values at which we evaluate the slopes.
\itemize{
\item Warning: Please avoid modifying your dataset between fitting the model and calling a \code{marginaleffects} function. This can sometimes lead to unexpected results.
\item \code{NULL} (default): Unit-level slopes for each observed value in the dataset (empirical distribution). The dataset is retrieved using \code{\link[insight:get_data]{insight::get_data()}}, which tries to extract data from the environment. This may produce unexpected results if the original data frame has been altered since fitting the model.
\item \code{\link[=datagrid]{datagrid()}} call to specify a custom grid of regressors. For example:
\itemize{
\item \code{newdata = datagrid(cyl = c(4, 6))}: \code{cyl} variable equal to 4 and 6 and other regressors fixed at their means or modes.
\item See the Examples section and the \code{\link[=datagrid]{datagrid()}} documentation.
}
\item \code{\link[=subset]{subset()}} call with a single argument to select a subset of the dataset used to fit the model, ex: \code{newdata = subset(treatment == 1)}
\item \code{\link[dplyr:filter]{dplyr::filter()}} call with a single argument to select a subset of the dataset used to fit the model, ex: \code{newdata = filter(treatment == 1)}
\item string:
\itemize{
\item "mean": Slopes evaluated when each predictor is held at its mean or mode.
\item "median": Slopes evaluated when each predictor is held at its median or mode.
\item "balanced": Slopes evaluated on a balanced grid with every combination of categories and numeric variables held at their means.
\item "tukey": Slopes evaluated at Tukey's 5 numbers.
\item "grid": Slopes evaluated on a grid of representative numbers (Tukey's 5 numbers and unique values of categorical predictors).
}
}}

\item{type}{string indicates the type (scale) of the predictions used to
compute contrasts or slopes. This can differ based on the model
type, but will typically be a string such as: "response", "link", "probs",
or "zero". When an unsupported string is entered, the model-specific list of
acceptable values is returned in an error message. When \code{type} is \code{NULL}, the
first entry in the error message is used by default.}
}
\value{
A named square matrix of variance and covariances. The names must match the coefficient names.
}
\description{
Mostly for internal use, but can be useful because the output is consistent across model classes.
}
\keyword{internal}
