% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.AllClasses.R
\docType{class}
\name{march.Dcmm-class}
\alias{march.Dcmm-class}
\title{A Double Chain Markov Model (DCMM).}
\description{
This class describes a Double Chain Markov Model (DCMM) represented by Pi, the probability distributions of the first
hidden states; by A, the transition matrix between hidden states; by RB, the transition matrix between sucessive output.
march. Dcmm extends \code{\link{march.Model-class}} class and therefore inherits its slots.
}
\details{
The model used here is described in :
\itemize{
 \item Berchtold, A.: The Double Chain Markov Model. Commun. Stat., Theory Methods 28 (1999), pp. 2569-2589  
 \item Berchtold, A.: High-order extensions of the Double Chain Markov Model. Stochastic Models 18 (2002), pp. 193-227.  
}
}
\section{Slots}{

 \describe{
   \item{\code{Pi}:}{A 3D matrix of \code{\link{numeric}} representing the probability distribution 
   of the first hidden state.}
   \item{\code{A}:}{A matrix of \code{\link{numeric}} representing the transition matrix between hidden states.}
   \item{\code{RB}:}{A 3D matrix of \code{\link{numeric}} representing the transition matrix between successive 
   output, in a reduced form.}
   \item{\code{M}:}{An \code{\link{integer}} value representing the number of hidden state.}
   \item{\code{orderVC}:}{An \code{\link{integer}} value representing the order of the visible Markov chain.}
   \item{\code{orderHC}:}{An \code{\link{integer}} value representing the order of the hidden Markov chain.}
  \item{\code{Amodel}:}{A vector of \code{\link{character}} string representing the modeling of the hidden transition matrix (complete, mtd or mtdg)}
  \item{\code{Cmodel}:}{A vector of \code{\link{character}} string representing the modeling of the visible transition matrix (complete, mtd or mtdg)}
 }
}

\seealso{
\code{\link{march.dcmm.construct}}, \code{\link{march.Model-class}}.
}
