% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_label.R
\name{mf_label}
\alias{mf_label}
\title{Plot labels}
\usage{
mf_label(
  x,
  var,
  col,
  cex = 0.7,
  overlap = TRUE,
  lines = TRUE,
  halo = FALSE,
  bg,
  r = 0.1,
  ...
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{col}{labels color, it can be a single color or a vector of colors}

\item{cex}{labels cex, it can be a single size or a vector of sizes}

\item{overlap}{if FALSE, labels are moved so they do not overlap.}

\item{lines}{if TRUE, then lines are plotted between x,y and the word,
for those words not covering their x,y coordinate}

\item{halo}{if TRUE, a 'halo' is displayed around the text and additional
arguments bg and r can be modified to set the color and width of the halo.}

\item{bg}{halo color, it can be a single color or a vector of colors}

\item{r}{width of the halo, it can be a single value or a vector of values}

\item{...}{further \link{text} arguments.}
}
\value{
No return value, labels are displayed.
}
\description{
Put labels on a map.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mtq$cex <- c(rep(.8, 8), 2, rep(.8, 25))
mf_label(
  x = mtq, var = "LIBGEO", col = "grey10", halo = TRUE, cex = mtq$cex,
  overlap = FALSE, lines = FALSE
)
}
