% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_background.R
\name{mf_background}
\alias{mf_background}
\title{Plot a background image}
\usage{
mf_background(filename, ...)
}
\arguments{
\item{filename}{filename of the background image, PNG or JPG/JPEG format.}

\item{...}{further parameters for
\code{\link[graphics:rasterImage]{rasterImage}}}
}
\value{
No return value, a background image is displayed.
}
\description{
Plot a background image on an existing plot
}
\examples{
mtq <- mf_get_mtq()
mf_init(mtq)
mf_background(system.file("img/background.jpg", package = "mapsf"))
mf_map(mtq, lwd = 3, col = NA, border = "white", add = TRUE)
mf_credits(
  txt = "Background photo by Noita Digital on Unsplash",
  col = "white"
)
}
