% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_map_r.R
\name{mf_raster}
\alias{mf_raster}
\title{Plot a raster}
\usage{
mf_raster(x, add = FALSE, ...)
}
\arguments{
\item{x}{a RasterLayer or RasterBrick object}

\item{add}{whether to add the layer to an existing plot (TRUE) or
not (FALSE).}

\item{...}{bgalpha, interpolate, or other arguments passed to be passed to
\code{\link[raster:plotRGB]{plotRGB}} or  \code{\link[raster:plotRGB]{plot}}}
}
\value{
No return value, a map is displayed.
}
\description{
Plot a raster object over a map (RasterLayer and RasterBrick).
}
\note{
This function is a wrapper for \code{\link[raster:plotRGB]{plotRGB}}
and  \code{\link[raster:plotRGB]{plot}}
from the raster package. The accuracy of the final plot depends on the
quality of the \code{*.png} file, the scale of \code{x} and the resolution
setup of the graphic device.
}
\examples{
library("raster")
r <- raster(system.file("external/test.grd", package = "raster"))
mf_raster(r)
}
