% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_geocode.R
\encoding{UTF-8}
\name{mp_geocode}
\alias{mp_geocode}
\title{Get geocoded coordinates using the Google Maps Geocoding API}
\usage{
mp_geocode(addresses, region = NULL, key = NULL)
}
\arguments{
\item{addresses}{Addresses to geocode, as \code{character} vector}

\item{region}{The region code, specified as a ccTLD ("top-level domain") two-character value (e.g. \code{"es"} for Spain) (optional)}

\item{key}{Google APIs key (optional)}
}
\value{
\code{list} of XML documents with Google Maps Geocoding API responses, one item per element in \code{addresses}
}
\description{
Get geocoded coordinates using the Google Maps Geocoding API
}
\note{
\itemize{
\item Use function \strong{\code{\link{mp_get_points}}} to extract \strong{locations} as \code{sf} point layer
\item Use function \strong{\code{\link{mp_get_bounds}}} to extract \strong{location bounds} as \code{sf} polygonal layer
}
}
\examples{

# Built-in reponse example
library(xml2)
doc = list("Tel-Aviv" = as_xml_document(response_geocode))
pnt = mp_get_points(doc)
bounds = mp_get_bounds(doc)

\dontrun{

# Basic use
doc = mp_geocode(addresses = c("Rehovot", "Beer-Sheva", "New-York"))

# Using the 'region' parameter
doc = mp_geocode(addresses = "Toledo")
mp_get_points(doc)
doc = mp_geocode(addresses = "Toledo", region = "es")
mp_get_points(doc)

# Various addresses
addresses = c(
  "Baker Street 221b, London",
  "Brandenburger Tor, Berlin",
  "",
  "Platz der Deutschen Einheit 1, Hamburg",
  "Arc de Triomphe de l'Etoile, Paris",
  NA
)
doc = mp_geocode(addresses)
pnt = mp_get_points(doc)

# Using API key
key = readLines("~/key") # Text file with API key
doc = mp_geocode(addresses, key = key)
pnt = mp_get_points(doc)

}
}
