% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{map_plot}
\alias{map_plot}
\title{Base R mapping}
\usage{
map_plot(x, lon = "longitude", lat = "latitude", color = NULL, size = 1,
  pch = 16, hull = FALSE, ...)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{SpatialPoints}, \code{SpatialPointsDataFrame}, or
\code{data.frame}. The package \pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess, but
if nothing close, we stop. Default: \code{longitude} and \code{latitude}}

\item{color}{Default color of your points.}

\item{size}{point size, Default: 1}

\item{pch}{point symbol shape, Default: 16}

\item{hull}{(logical) whether to add a convex hull. Default: \code{FALSE}}

\item{...}{Further args to \code{\link{points}}}
}
\value{
Plots a world scale map
}
\description{
Base R mapping
}
\examples{
# map spocc output, here using a built in object
data(occdat_eg1)
map_plot(occdat_eg1)

# map rgbif output, here using a built in object
data(gbif_eg1)
map_plot(gbif_eg1)

}

