% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segreg_poly.R
\name{segreg_poly}
\alias{segreg_poly}
\title{Polysomic segregation frequency}
\usage{
segreg_poly(m, dP, dQ)
}
\arguments{
\item{m}{the ploidy level}

\item{dP}{the dosage in parent P}

\item{dQ}{the dosage in parent Q}
}
\value{
a vector containing the expected segregation frequency for
    all possible genotypic classes.
}
\description{
Computes the polysomic segregation frequency given a ploidy level
and the dosage of the locus in both parents. It does not consider
double reduction.
}
\examples{
# autohexaploid with two and three doses in parents P and Q,
# respectively
seg<-segreg_poly(m=6, dP=2, dQ=3)
barplot(seg, las=2)

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
    
    Serang O, Mollinari M, Garcia AAF (2012) Efficient Exact 
    Maximum a Posteriori Computation for Bayesian SNP 
    Genotyping in Polyploids. _PLoS ONE_ 7(2): 
    e30906. \url{https://doi.org/10.1371/journal.pone.0030906}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
