% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from_polymapR.R
\name{import_data_from_polymapR}
\alias{import_data_from_polymapR}
\title{Import data from polymapR}
\usage{
import_data_from_polymapR(
  input.data,
  ploidy,
  parent1 = "P1",
  parent2 = "P2",
  input.type = c("discrete", "probabilistic"),
  prob.thres = 0.95,
  pardose = NULL,
  offspring = NULL,
  filter.non.conforming = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{input.data}{a \code{polymapR} dataset}

\item{ploidy}{the ploidy level}

\item{parent1}{a character string containing the name (or pattern of genotype IDs) of parent 1}

\item{parent2}{a character string containing the name (or pattern of genotype IDs) of parent 2}

\item{input.type}{Indicates whether the input is discrete ("disc") or probabilistic ("prob")}

\item{prob.thres}{threshold probability to assign a dosage to offspring. If the probability 
is smaller than \code{thresh.parent.geno}, the data point is converted to 'NA'.}

\item{pardose}{matrix of dimensions (n.mrk x 3) containing the name of the markers in the first column, and the 
dosage of parents 1 and 2 in columns 2 and 3. (see polymapR vignette)}

\item{offspring}{a character string containing the name (or pattern of genotype IDs) of the offspring 
individuals. If \code{NULL} (default) it considers all individuals as offsprings, except 
\code{parent1} and \code{parent2}.}

\item{filter.non.conforming}{if \code{TRUE} exclude samples with non 
expected genotypes under no double reduction. Since markers were already filtered in polymapR, the default is 
\code{FALSE}.}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\description{
Function to import datasets from polymapR
}
\examples{
require(polymapR)
data("screened_data3")
mappoly.data <- import_data_from_polymapR(screened_data3, 4)
plot(mappoly.data)

}
\references{
Bourke PM et al: (2019) PolymapR — linkage analysis and genetic map 
    construction from F1 populations of outcrossing polyploids. 
    _Bioinformatics_ 34:3496–3502.
    \url{https://doi.org/10.1093/bioinformatics/bty1002}

    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari \email{mmollin@ncsu.edu}
}
