% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quilting_hut.R
\name{create_width_balanced_cover}
\alias{create_width_balanced_cover}
\title{Generate an overlapping cover of an interval}
\usage{
create_width_balanced_cover(min_val, max_val, num_bins, percent_overlap)
}
\arguments{
\item{min_val}{The left endpoint \eqn{a}. A real number.}

\item{max_val}{The right endpoint \eqn{b}. A real number.}

\item{num_bins}{The number of cover intervals with which to cover the interval. A positive integer.}

\item{percent_overlap}{How much overlap desired between the cover intervals
(the percent of the intersection of each interval with its immediate
neighbor relative to its length, e.g., \eqn{[0,2]} and \eqn{[1,3]} would have \eqn{50\%} overlap).
A real number between 0 and 100, inclusive.}
}
\value{
A 2D numeric array.
\itemize{
\item left_ends - The left endpoints of the cover intervals.
\item right_ends - The right endpoints of the cover intervals.
}
}
\description{
This is a function that generates a cover of an interval \eqn{[a,b]} with
some number of (possibly) overlapping, evenly spaced, identical width subintervals.
}
\examples{
create_width_balanced_cover(min_val=0, max_val=100, num_bins=10, percent_overlap=15)
create_width_balanced_cover(-11.5, 10.33, 100, 2)
}
