% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_fatalities.R
\name{fatalities}
\alias{fatalities}
\alias{calc_fatalities}
\title{Calculate number of fatalities of violent conflict from UCDP GED}
\usage{
calc_fatalities(years = 1989:2023, precision_location = 1, precision_time = 1)
}
\arguments{
\item{years}{A numeric vector indicating the years for which to summarize
fatalities.}

\item{precision_location}{A numeric indicating precision value for the
geolocation up to which events are included. Defaults to 1.}

\item{precision_time}{A numeric indicating the precision value of the
temporal coding up to which events are included. Defaults to 1.}
}
\value{
A function that returns a tibble with a column for the date
(year and month), the type of violence an counts of civilian fatalities,
unknown fatalities and the total sum of fatalities.
}
\description{
The indicator aggregated the number of fatalities within a given asset
on a monthly cadence stratified by the type of conflict. The different types
of conflicts encoded in the UCDP GED database are:
\itemize{
\item state-based conflict
\item non-state conflict
\item one-sided violence
}
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{ucdp_ged}
}

You may apply quality filters based on the precision of the geolocation
of events and the temporal precision. By default, these are set to only
include events with the highest precision scores.

For geo-precision there are levels 1 to 7 with decreasing accuracy:
\itemize{
\item value 1: the location information corresponds exactly to the geographical
coordinates available
\item value 2: the location information refers to a limited area around a
specified location
\item value 3: the source refers to or can be specified to a larger location at
the level of second order administrative divisions (ADM2), such as district
or municipality, the GED uses centroid point coordinates for that ADM2.
\item value 4: the location information refers to a first order administrative
division, such as a province (ADM1), the GED uses the coordinates for the
centroid point of ADM1
\item value 5: is used in different cases if the source refers to parts of a
country which are larger than ADM1, but smaller than the entire country;
if two locations are mentioned a representiative point in between is
selected; if the location mentioned is an non-independend island; if
the location is not very specifically mentioned or in relation to another
location
\item value 6: the location mentioned refers to an entire country and its
centroid is used
\item value 7: If the event takes place over water or in international airspace,
the geographical coordinates in the dataset either represent the centroid
point of a certain water area or estimated coordinates
}

For temporal precision there are levels 1 to 5 with decreasing precision:
\itemize{
\item value 1: if the exact date of an event is known
\item value 2: if start and enddates for events are of unspecified character,
spanning more than one calendar day though no longer than six days
\item value 3: if when start and end dates for events are specified to a certain
week, but specific dates are not provided
\item value 4: if start and end dates for events are specified to a certain month
\item value 5: if start and enddates for events are specified to a certain year,
but specific dates are not provided
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "burundi.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_ucdp_ged(version = "22.1")) \%>\%
  calc_indicators(
    calc_fatalities(
      years = 1991:1992,
      precision_location = 1,
      precision_time = 1
    )
  ) \%>\%
  tidyr::unnest(fatalities)

aoi
}
}
\references{
Sundberg, Ralph, and Erik Melander, 2013, “Introducing the UCDP
Georeferenced Event Dataset”, Journal of Peace Research, vol.50, no.4, 523-532
}
\keyword{indicator}
