% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_wcprec.R
\docType{data}
\name{wcprec}
\alias{wcprec}
\title{Calculate precipitation statistics}
\format{
A tibble with a column for precipitation statistics (in mm)
}
\description{
This function allows to efficiently calculate precipitation statistics
from Worldclim for polygons. For each polygon, the desired statistic/s (min,
max, sum, mean, median, sd or var) is/are returned.
The required resources for this indicator are:
\itemize{
\item precipitation layer from \link{worldclim}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_worldclim}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
library(sf)
library(mapme.biodiversity)
(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg", package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2018,
    outdir = system.file("res", package = "mapme.biodiversity"),
    tmpdir = system.file("tmp", package = "mapme.biodiversity"),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("precipitation") \%>\%
  calc_indicators("wcprec", stats_worldclim = c("mean", "median"), engine = "extract") \%>\%
  tidyr::unnest(wcprec))
}
\keyword{indicator}
