% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{leaflet.providersESP.df}
\alias{leaflet.providersESP.df}
\title{Public WMS and WMTS of Spain}
\format{
A data frame object with a list of the required parameters for calling
the service:
\itemize{
\item \strong{provider}: Provider name.
\item \strong{field}: Description of \code{value}.
\item \strong{value}: INE code of each province.
}
}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.2.0}.
}
\description{
A data frame containing information of different public WMS and WMTS
providers of Spain

This function is a implementation of the javascript plugin
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
\strong{v1.2.0}.
}
\details{
Providers available to be passed to \code{type} on \code{\link[=esp_getTiles]{esp_getTiles()}} are:\tabular{l}{
   provider \cr
   'IDErioja' \cr
   'IGNBase' \cr
   'IGNBase.Todo' \cr
   'IGNBase.Gris' \cr
   'IGNBase.TodoNoFondo' \cr
   'IGNBase.Orto' \cr
   'MDT' \cr
   'MDT.Elevaciones' \cr
   'MDT.Relieve' \cr
   'MDT.CurvasNivel' \cr
   'PNOA' \cr
   'PNOA.MaximaActualidad' \cr
   'PNOA.Mosaico' \cr
   'OcupacionSuelo' \cr
   'OcupacionSuelo.Ocupacion' \cr
   'OcupacionSuelo.Usos' \cr
   'LiDAR' \cr
   'MTN' \cr
   'Geofisica' \cr
   'Geofisica.Terremotos10dias' \cr
   'Geofisica.Terremotos30dias' \cr
   'Geofisica.Terremotos365dias' \cr
   'Geofisica.VigilanciaVolcanica' \cr
   'CaminoDeSantiago' \cr
   'CaminoDeSantiago.CaminoFrances' \cr
   'CaminoDeSantiago.CaminosTuronensis' \cr
   'CaminoDeSantiago.CaminosGalicia' \cr
   'CaminoDeSantiago.CaminosDelNorte' \cr
   'CaminoDeSantiago.CaminosAndaluces' \cr
   'CaminoDeSantiago.CaminosCentro' \cr
   'CaminoDeSantiago.CaminosEste' \cr
   'CaminoDeSantiago.CaminosCatalanes' \cr
   'CaminoDeSantiago.CaminosSureste' \cr
   'CaminoDeSantiago.CaminosInsulares' \cr
   'CaminoDeSantiago.CaminosPiemonts' \cr
   'CaminoDeSantiago.CaminosTolosana' \cr
   'CaminoDeSantiago.CaminosPortugueses' \cr
   'Catastro' \cr
   'Catastro.Catastro' \cr
   'Catastro.Parcela' \cr
   'Catastro.CadastralParcel' \cr
   'Catastro.CadastralZoning' \cr
   'Catastro.Address' \cr
   'Catastro.Building' \cr
   'RedTransporte' \cr
   'RedTransporte.Carreteras' \cr
   'RedTransporte.Ferroviario' \cr
   'RedTransporte.Aerodromo' \cr
   'RedTransporte.AreaServicio' \cr
   'RedTransporte.EstacionesFerroviario' \cr
   'RedTransporte.Puertos' \cr
   'Cartociudad' \cr
   'Cartociudad.CodigosPostales' \cr
   'Cartociudad.Direcciones' \cr
   'NombresGeograficos' \cr
   'UnidadesAdm' \cr
   'UnidadesAdm.Limites' \cr
   'UnidadesAdm.Unidades' \cr
   'Hidrografia' \cr
   'Hidrografia.MasaAgua' \cr
   'Hidrografia.Cuencas' \cr
   'Hidrografia.Subcuencas' \cr
   'Hidrografia.POI' \cr
   'Hidrografia.ManMade' \cr
   'Hidrografia.LineaCosta' \cr
   'Hidrografia.Rios' \cr
   'Hidrografia.Humedales' \cr
   'Militar' \cr
   'Militar.CEGET1M' \cr
   'Militar.CEGETM7814' \cr
   'Militar.CEGETM7815' \cr
   'Militar.CEGETM682' \cr
   'Militar.CECAF1M' \cr
   'ADIF' \cr
   'ADIF.Vias' \cr
   'ADIF.Nodos' \cr
   'ADIF.Estaciones' \cr
   'LimitesMaritimos' \cr
   'LimitesMaritimos.LimitesMaritimos' \cr
   'LimitesMaritimos.LineasBase' \cr
   'Copernicus' \cr
   'Copernicus.LandCover' \cr
   'Copernicus.Forest' \cr
   'Copernicus.ForestLeaf' \cr
   'Copernicus.WaterWet' \cr
   'Copernicus.SoilSeal' \cr
   'Copernicus.GrassLand' \cr
   'Copernicus.Local' \cr
   'Copernicus.RiparianGreen' \cr
   'Copernicus.RiparianLandCover' \cr
   'Copernicus.Natura2k' \cr
   'Copernicus.UrbanAtlas' \cr
   'ParquesNaturales' \cr
   'ParquesNaturales.Limites' \cr
   'ParquesNaturales.ZonasPerifericas' \cr
}
}
\examples{
data("leaflet.providersESP.df")

library(tibble)

as_tibble(leaflet.providersESP.df)
}
\seealso{
Other datasets: 
\code{\link{esp_codelist}},
\code{\link{esp_munic.sf}},
\code{\link{esp_nuts.sf}},
\code{\link{pobmun19}}

Other imagery utilities: 
\code{\link{addProviderEspTiles}()},
\code{\link{esp_getTiles}()}
}
\concept{datasets}
\concept{imagery utilities}
