% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_potter}
\alias{ison_potter}
\title{Six complex one-mode support data in Harry Potter books (Bossaert and Meidert 2013)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> $book1
#> # A labelled, complex, directed network of 64 nodes and 47 arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 47 x 2
#>    from    to
#>   <int> <int>
#> 1    11    11
#> 2    11    25
#> 3    11    26
#> 4    11    44
#> 5    11    56
#> 6    11    58
#> # i 41 more rows
#> 
#> $book2
#> # A labelled, complex, directed network of 64 nodes and 110 arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 110 x 2
#>    from    to
#>   <int> <int>
#> 1     2     2
#> 2     2     3
#> 3     2    19
#> 4     2    20
#> 5     2    25
#> 6     2    26
#> # i 104 more rows
#> 
#> $book3
#> # A labelled, complex, directed network of 64 nodes and 104 arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 104 x 2
#>    from    to
#>   <int> <int>
#> 1     2     2
#> 2     2     3
#> 3     2    19
#> 4     2    20
#> 5     2    25
#> 6     2    26
#> # i 98 more rows
#> 
#> $book4
#> # A labelled, complex, directed network of 64 nodes and 49 arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 49 x 2
#>    from    to
#>   <int> <int>
#> 1     7     7
#> 2     7     8
#> 3     7    25
#> 4     8     8
#> 5     8    25
#> 6     9     9
#> # i 43 more rows
#> 
#> $book5
#> # A labelled, complex, directed network of 64 nodes and 160 arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 160 x 2
#>    from    to
#>   <int> <int>
#> 1     2     2
#> 2     2     3
#> 3     2    19
#> 4     2    20
#> 5     2    25
#> 6     2    29
#> # i 154 more rows
#> 
#> $book6
#> # A labelled, complex, directed network of 64 nodes and 74 arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 74 x 2
#>    from    to
#>   <int> <int>
#> 1    11    11
#> 2    11    25
#> 3    11    56
#> 4    11    58
#> 5    12    12
#> 6    14    14
#> # i 68 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(ison_potter)
}
\description{
Goele Bossaert and Nadine Meidert coded peer support ties among 64 characters
in the Harry Potter books.
Each author coded four of seven books using NVivo,
with the seventh book coded by both and serving to assess inter-rater reliability.
The first six books concentrated on adolescent interactions,
were studied in their paper, and are made available here.
The peer support ties mean voluntary emotional, instrumental, or informational support,
or praise from one living, adolescent character to another within the book's pages.
In addition, nodal attributes name, schoolyear (which doubles as their age),
gender, and their house assigned by the sorting hat are included.
}
\references{
Bossaert, Goele and Nadine Meidert (2013).
"'We are only as strong as we are united, as weak as we are divided'. A dynamic analysis of the peer support networks in the Harry Potter books."
\emph{Open Journal of Applied Sciences}, 3(2): 174-185.
\doi{10.4236/ojapps.2013.32024}
}
\keyword{datasets}
