% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_is.R
\name{is}
\alias{is}
\alias{is_manynet}
\alias{is_graph}
\alias{is_edgelist}
\alias{is_twomode}
\alias{is_weighted}
\alias{is_directed}
\alias{is_labelled}
\alias{is_signed}
\alias{is_complex}
\alias{is_multiplex}
\alias{is_uniplex}
\alias{is_longitudinal}
\alias{is_dynamic}
\alias{is_connected}
\alias{is_perfect_matching}
\alias{is_eulerian}
\alias{is_acyclic}
\alias{is_aperiodic}
\title{Describing network formats}
\source{
https://stackoverflow.com/questions/55091438/r-igraph-find-all-cycles
}
\usage{
is_manynet(.data)

is_graph(.data)

is_edgelist(.data)

is_twomode(.data)

is_weighted(.data)

is_directed(.data)

is_labelled(.data)

is_signed(.data)

is_complex(.data)

is_multiplex(.data)

is_uniplex(.data)

is_longitudinal(.data)

is_dynamic(.data)

is_connected(.data)

is_perfect_matching(.data, mark = "type")

is_eulerian(.data)

is_acyclic(.data)

is_aperiodic(.data, max_path_length = 4)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{mark}{A logical vector marking two types or modes.
By default "type".}

\item{max_path_length}{Maximum path length considered.
If negative, paths of all lengths are considered.
By default 4, to avoid potentially very long computation times.}
}
\value{
TRUE if the condition is met, or FALSE otherwise.

TRUE if the condition is met, or FALSE otherwise.
}
\description{
These functions implement logical tests for various network properties.
All \verb{is_*()} functions return a logical scalar (TRUE or FALSE).

These functions implement logical tests for various network
properties.
}
\section{Functions}{
\itemize{
\item \code{is_manynet()}: Tests whether network is manynet-compatible

\item \code{is_graph()}: Tests whether network contains graph-level information

\item \code{is_edgelist()}: Tests whether data frame is an edgelist

\item \code{is_twomode()}: Tests whether network is a two-mode network

\item \code{is_weighted()}: Tests whether network is weighted

\item \code{is_directed()}: Tests whether network is directed

\item \code{is_labelled()}: Tests whether network includes names for the nodes

\item \code{is_signed()}: Tests whether network is signed positive/negative

\item \code{is_complex()}: Tests whether network contains any loops

\item \code{is_multiplex()}: Tests whether network is multiplex,
either from multiple rows with the same sender and receiver,
or multiple columns to the edgelist.

\item \code{is_uniplex()}: Tests whether network is simple (both uniplex and simplex)

\item \code{is_longitudinal()}: Tests whether network is longitudinal, panel data

\item \code{is_dynamic()}: Tests whether network is dynamic, time-stamped data

\item \code{is_connected()}: Tests whether network is weakly connected if
the network is undirected or strongly connected if directed.
To test weak connection on a directed network,
please see \code{to_undirected()}.

\item \code{is_perfect_matching()}: Tests whether there is a matching for a network
that covers every node in the network

\item \code{is_eulerian()}: Tests whether there is a Eulerian path for a network
where that path passes through every tie exactly once
@importFrom igraph has_eulerian_path

\item \code{is_acyclic()}: Tests whether network is a directed acyclic graph

\item \code{is_aperiodic()}: Tests whether network is aperiodic

}}
\examples{
is_manynet(create_filled(2))
is_graph(create_star(2))
is_edgelist(matrix(c(2,2), 1, 2))
is_edgelist(as_edgelist(matrix(c(2,2), 1, 2)))
is_twomode(create_filled(c(2,2)))
is_weighted(create_tree(3))
is_directed(create_tree(2))
is_directed(create_tree(2, directed = TRUE))
is_labelled(create_empty(3))
is_signed(create_lattice(3))
is_complex(create_lattice(4))
is_multiplex(create_filled(c(3,3)))
is_uniplex(create_star(3))
is_longitudinal(create_tree(5, 3))
is_dynamic(create_tree(3))
is_connected(ison_southern_women)
is_perfect_matching(ison_southern_women)
is_eulerian(ison_brandes)
is_acyclic(ison_algebra)
is_aperiodic(ison_algebra)
}
\seealso{
Other mapping: 
\code{\link{attributes}()},
\code{\link{autographing}},
\code{\link{configuration_layouts}},
\code{\link{partition_layouts}},
\code{\link{properties}}
}
\concept{mapping}
\concept{marks}
