% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_add.R
\name{add}
\alias{add}
\alias{add_nodes}
\alias{delete_nodes}
\alias{add_ties}
\alias{add_node_attribute}
\alias{add_tie_attribute}
\title{Adding nodes and ties and their attributes}
\usage{
add_nodes(.data, nodes, attribute = NULL)

delete_nodes(.data, nodes)

add_ties(.data, ties, attribute = NULL)

add_node_attribute(.data, attr_name, vector)

add_tie_attribute(.data, attr_name, vector)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{nodes}{The number of nodes to be added.}

\item{attribute}{A named list to be added as tie or node attributes.}

\item{ties}{The number of ties to be added or an even list of ties.}

\item{attr_name}{Name of the new attribute in the resulting object.}

\item{vector}{A vector of values for the new attribute.}
}
\value{
A data object of the same class as the function was given.
}
\description{
These functions allow users to add nodes, ties, or attributes to the nodes or ties
of a network.
The \verb{add_*()} functions operate similarly to in \code{{igraph}}.

Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrr}{
    \tab igraph \tab network \tab tbl_graph \cr
   add_nodes \tab 1 \tab 1 \tab 1 \cr
   add_ties \tab 1 \tab 1 \tab 1 \cr
   delete_nodes \tab 1 \tab 0 \tab 0 \cr
}
}
\section{Functions}{
\itemize{
\item \code{add_nodes()}: Add additional nodes to a network

\item \code{delete_nodes()}: Delete nodes in a network

\item \code{add_ties()}: Add additional ties to a network

\item \code{add_node_attribute()}: Add a vector of values to a network as a nodal attribute.

\item \code{add_tie_attribute()}: Add a vector of values to a network as a tie attribute.

}}
\examples{
  other <- create_filled(4) \%>\% mutate(name = c("A", "B", "C", "D"))
  add_nodes(other, 4, list(name = c("Matthew", "Mark", "Luke", "Tim")))
  add_tie_attribute(other, "weight", c(1, 2, 2, 2, 1, 2))
}
\seealso{
Other manipulations: 
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{tidy}},
\code{\link{transform}()}
}
\concept{manipulations}
