% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_mod_levels.R
\name{merge_mod_levels}
\alias{merge_mod_levels}
\title{Merge the Generated Levels of
Moderators}
\usage{
merge_mod_levels(...)
}
\arguments{
\item{...}{The output from
\code{\link[=mod_levels]{mod_levels()}}, or a list of levels
generated by \code{\link[=mod_levels_list]{mod_levels_list()}}.}
}
\value{
A \code{wlevels}-class object,
which is a data frame of the
combinations of levels, with
additional attributes about the
levels.
}
\description{
Merge the levels of
moderators generated by
\code{\link[=mod_levels]{mod_levels()}} into a data frame.
}
\details{
It merges the levels of
moderators generated by
\code{\link[=mod_levels]{mod_levels()}} into a data frame,
with each row represents a
combination of the levels. The output
is to be used by
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.

Users usually do not need to use this
function because
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}} will merge
the levels internally if necessary.
This function is used when users need
to customize the levels for each
moderator and so cannot use
\code{\link[=mod_levels_list]{mod_levels_list()}} or the default
levels in \code{\link[=cond_indirect_effects]{cond_indirect_effects()}}.
}
\examples{

data(data_med_mod_ab)
dat <- data_med_mod_ab
# Form the levels from a list of lm() outputs
lm_m <- lm(m ~ x*w1 + c1 + c2, dat)
lm_y <- lm(y ~ m*w2 + x + w1 + c1 + c2, dat)
lm_out <- lm2list(lm_m, lm_y)
w1_levels <- mod_levels(lm_out, w = "w1")
w1_levels
w2_levels <- mod_levels(lm_out, w = "w2")
w2_levels
merge_mod_levels(w1_levels, w2_levels)

}
\seealso{
\code{\link[=mod_levels]{mod_levels()}} on generating
the levels of a moderator.
}
