% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_boot.R
\name{do_boot}
\alias{do_boot}
\title{Bootstrap Estimates for
'indirect_effects' and
'cond_indirect_effects'}
\usage{
do_boot(
  fit,
  R = 100,
  seed = NULL,
  parallel = TRUE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE
)
}
\arguments{
\item{fit}{Either (a) a list of \code{lm}
class objects, or the output of
\code{\link[=lm2list]{lm2list()}} (i.e., an \code{lm_list}-class
object), or (b) the output of
\code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{R}{The number of bootstrap
samples. Default is 100.}

\item{seed}{The seed for the
bootstrapping. Default is \code{NULL} and
seed is not set.}

\item{parallel}{Logical. Whether
parallel processing will be used.
Default is \code{TRUE}. If \code{fit} is a list
of \code{\link[=lm]{lm()}} outputs, parallel
processing will not be used.}

\item{ncores}{Integer. The number of
CPU cores to use when \code{parallel} is
\code{TRUE}. Default is the number of
non-logical cores minus one (one
minimum). Will raise an error if
greater than the number of cores
detected by
\code{\link[parallel:detectCores]{parallel::detectCores()}}. If
\code{ncores} is set, it will override
\code{make_cluster_args}.}

\item{make_cluster_args}{A named list
of additional arguments to be passed
to \code{\link[parallel:makeCluster]{parallel::makeCluster()}}. For
advanced users. See
\code{\link[parallel:makeCluster]{parallel::makeCluster()}} for
details. Default is \code{list()}, no
additional arguments.}

\item{progress}{Logical. Display
progress or not. Default is \code{TRUE}.}
}
\value{
A \code{boot_out}-class object
that can be used for the \code{boot_out}
argument of
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}} for forming
bootstrap confidence intervals. The
object is a list with the number of
elements equal to the number of
bootstrap samples. Each element is a
list of the parameter estimates and
sample variances and covariances of
the variables in each bootstrap
sample.
}
\description{
Generate bootstrap
estimates to be used by
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}},
}
\details{
It does nonparametric
bootstrapping to generate bootstrap
estimates of the parameter estimates
in a model fitted either by
\code{\link[lavaan:sem]{lavaan::sem()}} or by a sequence of
calls to \code{\link[=lm]{lm()}}. The stored estimates
can then be used by
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}} to form
bootstrapping confidence intervals.

This approach removes the need to
repeat bootstrapping in each call to
\code{\link[=cond_indirect_effects]{cond_indirect_effects()}},
\code{\link[=indirect_effect]{indirect_effect()}}, and
\code{\link[=cond_indirect]{cond_indirect()}}. It also ensures
that the same set of bootstrap
samples is used in all subsequent
analysis.

It determines the type of the fit
object automatically and then calls
\code{\link[=lm2boot_out]{lm2boot_out()}}, \code{\link[=fit2boot_out]{fit2boot_out()}}, or
\code{\link[=fit2boot_out_do_boot]{fit2boot_out_do_boot()}}.
}
\examples{
data(data_med_mod_ab1)
dat <- data_med_mod_ab1
lm_m <- lm(m ~ x*w + c1 + c2, dat)
lm_y <- lm(y ~ m*w + x + c1 + c2, dat)
lm_out <- lm2list(lm_m, lm_y)
# In real research, R should be 2000 or even 5000
# In real research, no need to set parallel and progress to FALSE
# Parallel processing is enabled by default and
# progress is displayed by default.
lm_boot_out <- do_boot(lm_out, R = 50, seed = 1234,
                       parallel = FALSE,
                       progress = FALSE)
wlevels <- mod_levels(w = "w", fit = lm_out)
wlevels
out <- cond_indirect_effects(wlevels = wlevels,
                             x = "x",
                             y = "y",
                             m = "m",
                             fit = lm_out,
                             boot_ci = TRUE,
                             boot_out = lm_boot_out)
out

}
\seealso{
\code{\link[=lm2boot_out]{lm2boot_out()}},
\code{\link[=fit2boot_out]{fit2boot_out()}}, and
\code{\link[=fit2boot_out_do_boot]{fit2boot_out_do_boot()}}, which
implements the bootstrapping.
}
