% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_indirect.R
\name{print.indirect}
\alias{print.indirect}
\title{Print an 'indirect' Class
Object}
\usage{
\method{print}{indirect}(x, digits = 3, pvalue = FALSE, pvalue_digits = 3, ...)
}
\arguments{
\item{x}{The output of
\code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.}

\item{digits}{Number of digits to
display. Default is 3.}

\item{pvalue}{Logical. If \code{TRUE},
asymmetric \emph{p}-value based on
bootstrapping will be printed if
available.}

\item{pvalue_digits}{Number of decimal
places to display for the \emph{p}-value.
Default is 3.}

\item{...}{Other arguments. Not used.}
}
\value{
\code{x} is returned invisibly.
Called for its side effect.
}
\description{
Print the content of the
output of \code{\link[=indirect_effect]{indirect_effect()}} or
\code{\link[=cond_indirect]{cond_indirect()}}.
}
\details{
The \code{print} method of the
\code{indirect}-class object.

If bootstrapping confidence interval
was requested, this method has the
option to print a
\emph{p}-value computed by the
method presented in Asparouhov and Muthén (2021).
Note that this \emph{p}-value is asymmetric
bootstrap \emph{p}-value based on the
distribution of the bootstrap estimates.
It is not computed based on the
distribution under the null hypothesis.

For a \emph{p}-value of \emph{a}, it means that
a 100(1 - \emph{a})\% bootstrapping confidence
interval
will have one of its limits equal to
0. A confidence interval
with a higher confidence level will
include zero, while a confidence
interval with a lower confidence level
will exclude zero.

We recommend using confidence interval
directly. Therefore, \emph{p}-value is not
printed by default. Nevertheless,
users who need it can request it
by setting \code{pvalue} to \code{TRUE}.
}
\examples{

library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x   + b1 * w1 + d1 * x:w1
m2 ~ a2 * m1  + b2 * w2 + d2 * m1:w2
m3 ~ a3 * m2  + b3 * w3 + d3 * m2:w3
y  ~ a4 * m3  + b4 * w4 + d4 * m3:w4
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

wvalues <- c(w1 = 5, w2 = 4, w3 = 2, w4 = 3)

indirect_1 <- cond_indirect(x = "x", y = "y",
                            m = c("m1", "m2", "m3"),
                            fit = fit,
                            wvalues = wvalues)
indirect_1

dat <- modmed_x1m3w4y1
mod2 <-
"
m1 ~ a1 * x
m2 ~ a2 * m1
m3 ~ a3 * m2
y  ~ a4 * m3 + x
"
fit2 <- sem(mod2, dat,
            meanstructure = TRUE, fixed.x = FALSE,
            se = "none", baseline = FALSE)
est <- parameterEstimates(fit)

indirect_2 <- indirect_effect(x = "x", y = "y",
                              m = c("m1", "m2", "m3"),
                              fit = fit2)
indirect_2
print(indirect_2, digits = 5)


}
\references{
Asparouhov, A., & Muthén, B. (2021). Bootstrap p-value computation.
Retrieved from https://www.statmodel.com/download/FAQ-Bootstrap\%20-\%20Pvalue.pdf
}
\seealso{
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}}
}
