% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticImage.R
\name{staticPlot}
\alias{staticPlot}
\alias{staticImage}
\title{Include a static image in a combinedWidgets}
\usage{
staticPlot(expr, width = 600, height = 400)

staticImage(file, style = "max-width:100\%\%;max-height:100\%\%")
}
\arguments{
\item{expr}{Expression that creates a static plot.}

\item{width}{Width of the image to create.}

\item{height}{Height of the image to create.}

\item{file}{path of the image to include.}

\item{style}{CSS style to apply to the image.}
}
\value{
a \code{shiny.tag} object containing the HTML code required to include
the image or the plot in a \code{combinedWidgets} object.
}
\description{
\code{staticPlot} is a function that generates a static plot and then return
the HTML code needed to include the plot in a combinedWidgets.
\code{staticImage} is a more general function that generates the HTML code
necessary to include any image file.
}
\examples{
staticPlot(hist(rnorm(100)))

if (require(plotly)) {
  data(iris)

  combineWidgets(
    plot_ly(iris, x = ~Sepal.Length, type = "histogram", nbinsx = 20),
    staticPlot(hist(iris$Sepal.Length, breaks = 20), height = 300)
  )

  # You can also embed static images in the header, footer, left or right
  # columns of a combinedWidgets. The advantage is that the space allocated
  # to the static plot will be constant when the window is resized.

  combineWidgets(
    plot_ly(iris, x = ~Sepal.Length, type = "histogram", nbinsx = 20),
    footer = staticPlot(hist(iris$Sepal.Length, breaks = 20), height = 300)
  )
}

}
