% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{mwCheckboxGroup}
\alias{mwCheckboxGroup}
\title{Add a group of checkboxes to a manipulateWidget gadget}
\usage{
mwCheckboxGroup(choices, value = c(), label = NULL, ..., .display = TRUE)
}
\arguments{
\item{choices}{Vector or list of choices. If it is named, then the names rather than the
values are displayed to the user.}

\item{value}{Vector containing the values initially selected}

\item{label}{Display label for the control. If \code{NULL}, the name of the corresponding
variable is used.}

\item{...}{Other arguments passed to function\code{\link[shiny]{checkboxGroupInput}}}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the input control should be shown/hidden.}
}
\value{
A function that will generate the input control.
}
\description{
Add a group of checkboxes to a manipulateWidget gadget
}
\examples{
if (require(plotly)) {
  manipulateWidget(
    {
      if (length(species) == 0) mydata <- iris
      else mydata <- iris[iris$Species \%in\% species,]

      plot_ly(mydata, x = ~Sepal.Length, y = ~Sepal.Width,
              color = ~droplevels(Species), type = "scatter", mode = "markers")
    },
    species = mwCheckboxGroup(levels(iris$Species))
  )
}

}
\seealso{
Other controls: \code{\link{mwCheckbox}},
  \code{\link{mwDateRange}}, \code{\link{mwDate}},
  \code{\link{mwGroup}}, \code{\link{mwNumeric}},
  \code{\link{mwPassword}}, \code{\link{mwRadio}},
  \code{\link{mwSelect}}, \code{\link{mwSlider}},
  \code{\link{mwText}}
}
