% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwUI.R
\name{mwUI}
\alias{mwUI}
\title{Generate the UI of a manipulateWidget gadget}
\usage{
mwUI(..., .controlPos = c("left", "top", "right", "bottom", "tab"),
  .tabColumns = 2, .updateBtn = FALSE, .main = "",
  .content = htmlOutput("output", style = "height:100\%;width:100\%"))
}
\arguments{
\item{...}{One or more named control arguments created with functions
\code{\link{mwSlider}}, \code{\link{mwText}}, etc. The name of each control
is the name of the variable the controls modifies in the expression. One
can also create a group of inputs by passing a list of such control
arguments. for instance
\code{mygroup = list(txt = mwText(""), nb = mwNumeric(0))} creates a group
of inputs named mygroup with two inputs named "txt" and "nb".}

\item{.controlPos}{Where controls should be placed ? By default, they are placed in the left,
next to the graphic. If \code{controlPos = "tab"}, two tabs are created:
one containing controls and the other containing the graphic.}

\item{.tabColumns}{If controls are placed in a distinct tab, how many columns should be
used ? This parameter is used only if \code{controlPos = "tab"}}

\item{.updateBtn}{Should an update button be added to the controls ? If \code{TRUE}, then
the graphic is updated only when the user clicks on the update button.}

\item{.main}{Title of the shiny gadget}

\item{.content}{HTML of the main content of the application, where outputs are displayed.}
}
\value{
A \code{shiny.tag.list} object that can be used in function
\code{\link[shiny]{runGadget}} as ui parameter.
}
\description{
This function can be used if you desire to create a gadget that has the same
UI as a manipulateWidget gadget but with a custom server logic.
}

