% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mangoro-utils.R
\name{mangoro_http_start}
\alias{mangoro_http_start}
\title{Start an HTTP file server via RPC}
\usage{
mangoro_http_start(
  sock,
  addr,
  dir = ".",
  prefix = "/",
  cors = FALSE,
  coop = FALSE,
  tls = FALSE,
  cert = NULL,
  key = NULL,
  silent = FALSE
)
}
\arguments{
\item{sock}{A nanonext socket connected to the HTTP server controller}

\item{addr}{Address to bind server to (e.g., "127.0.0.1:8080")}

\item{dir}{Directory to serve (default: current directory)}

\item{prefix}{URL prefix for the server (default: "/")}

\item{cors}{Enable CORS headers (default: FALSE)}

\item{coop}{Enable Cross-Origin-Opener-Policy (default: FALSE)}

\item{tls}{Enable TLS (default: FALSE)}

\item{cert}{Path to TLS certificate file (required if tls = TRUE)}

\item{key}{Path to TLS key file (required if tls = TRUE)}

\item{silent}{Suppress server logs (default: FALSE)}
}
\value{
List with status and message
}
\description{
Start an HTTP file server via RPC
}
