% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{simbrain}
\alias{simbrain}
\title{Generate simulation data Function}
\usage{
simbrain(
  baseimg,
  diffimg,
  sdevimg = NULL,
  mask = NULL,
  n0 = 10,
  c1 = 0.5,
  sd1 = 0.01,
  zeromask = FALSE,
  reduce = c("no", "rd1", "rd2")[1],
  output = c("rdata", "nifti")[1],
  seed = 1
)
}
\arguments{
\item{baseimg}{an array for the basis image.}

\item{diffimg}{an array for the difference image.}

\item{sdevimg}{an array for the standard deviation image.}

\item{mask}{an array for the mask image.}

\item{n0}{a numeric, which is a sample size per group.}

\item{c1}{a numeric,}

\item{sd1}{a numeric, standard deviation for the individual variation.}

\item{zeromask}{a logical, whether mask the position with zero values for all subjects.}

\item{reduce}{a vector.}

\item{output}{a vector.}

\item{seed}{a numeric for seed for random variables.}
}
\value{
\item{S}{data matrix}

\item{Z}{binary group variable}

\item{brainpos}{binary brain position.}

\item{imagedim}{three dimensional vector for image dimension}
}
\description{
This is a function for simulation data based on the real base brain image data and difference in brain between healty and disease groups.
}
\details{
\code{simbrain} requires a base brain image data and mean difference image data.
}
\examples{
data(baseimg)
data(diffimg)
sim1 = simbrain(baseimg = baseimg, diffimg = diffimg)

}
