/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.ExtractionConfidenceEstimator;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ConfidenceTokenizationFilter
implements TokenizationFilter,
Serializable {
    ExtractionConfidenceEstimator confidenceEstimator;
    TokenizationFilter underlyingFilter;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public ConfidenceTokenizationFilter(ExtractionConfidenceEstimator confidenceEstimator, TokenizationFilter underlyingFilter) {
        this.confidenceEstimator = confidenceEstimator;
        this.underlyingFilter = underlyingFilter;
    }

    @Override
    public LabeledSpans constructLabeledSpans(LabelAlphabet dict, Object document, Label backgroundTag, Tokenization input, Sequence seq) {
        DocumentExtraction extraction = new DocumentExtraction("Extraction", dict, input, seq, null, backgroundTag.toString());
        this.confidenceEstimator.estimateConfidence(extraction);
        return extraction.getExtractedSpans();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.confidenceEstimator);
        out.writeObject(this.underlyingFilter);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.confidenceEstimator = (ExtractionConfidenceEstimator)in.readObject();
        this.underlyingFilter = (TokenizationFilter)in.readObject();
    }
}

